/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateRuleRequest extends ElasticLoadBalancingV2Request implements
        ToCopyableBuilder<CreateRuleRequest.Builder, CreateRuleRequest> {
    private static final SdkField<String> LISTENER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateRuleRequest::listenerArn)).setter(setter(Builder::listenerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListenerArn").build()).build();

    private static final SdkField<List<RuleCondition>> CONDITIONS_FIELD = SdkField
            .<List<RuleCondition>> builder(MarshallingType.LIST)
            .getter(getter(CreateRuleRequest::conditions))
            .setter(setter(Builder::conditions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Conditions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RuleCondition> builder(MarshallingType.SDK_POJO)
                                            .constructor(RuleCondition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(CreateRuleRequest::priority)).setter(setter(Builder::priority))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Priority").build()).build();

    private static final SdkField<List<Action>> ACTIONS_FIELD = SdkField
            .<List<Action>> builder(MarshallingType.LIST)
            .getter(getter(CreateRuleRequest::actions))
            .setter(setter(Builder::actions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Actions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Action> builder(MarshallingType.SDK_POJO)
                                            .constructor(Action::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LISTENER_ARN_FIELD,
            CONDITIONS_FIELD, PRIORITY_FIELD, ACTIONS_FIELD));

    private final String listenerArn;

    private final List<RuleCondition> conditions;

    private final Integer priority;

    private final List<Action> actions;

    private CreateRuleRequest(BuilderImpl builder) {
        super(builder);
        this.listenerArn = builder.listenerArn;
        this.conditions = builder.conditions;
        this.priority = builder.priority;
        this.actions = builder.actions;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the listener.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the listener.
     */
    public String listenerArn() {
        return listenerArn;
    }

    /**
     * Returns true if the Conditions property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasConditions() {
        return conditions != null && !(conditions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The conditions. Each rule can include zero or one of the following conditions: <code>http-request-method</code>,
     * <code>host-header</code>, <code>path-pattern</code>, and <code>source-ip</code>, and zero or more of the
     * following conditions: <code>http-header</code> and <code>query-string</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasConditions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The conditions. Each rule can include zero or one of the following conditions:
     *         <code>http-request-method</code>, <code>host-header</code>, <code>path-pattern</code>, and
     *         <code>source-ip</code>, and zero or more of the following conditions: <code>http-header</code> and
     *         <code>query-string</code>.
     */
    public List<RuleCondition> conditions() {
        return conditions;
    }

    /**
     * <p>
     * The rule priority. A listener can't have multiple rules with the same priority.
     * </p>
     * 
     * @return The rule priority. A listener can't have multiple rules with the same priority.
     */
    public Integer priority() {
        return priority;
    }

    /**
     * Returns true if the Actions property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasActions() {
        return actions != null && !(actions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The actions. Each rule must include exactly one of the following types of actions: <code>forward</code>,
     * <code>fixed-response</code>, or <code>redirect</code>, and it must be the last action to be performed.
     * </p>
     * <p>
     * If the action type is <code>forward</code>, you specify one or more target groups. The protocol of the target
     * group must be HTTP or HTTPS for an Application Load Balancer. The protocol of the target group must be TCP, TLS,
     * UDP, or TCP_UDP for a Network Load Balancer.
     * </p>
     * <p>
     * [HTTPS listeners] If the action type is <code>authenticate-oidc</code>, you authenticate users through an
     * identity provider that is OpenID Connect (OIDC) compliant.
     * </p>
     * <p>
     * [HTTPS listeners] If the action type is <code>authenticate-cognito</code>, you authenticate users through the
     * user pools supported by Amazon Cognito.
     * </p>
     * <p>
     * [Application Load Balancer] If the action type is <code>redirect</code>, you redirect specified client requests
     * from one URL to another.
     * </p>
     * <p>
     * [Application Load Balancer] If the action type is <code>fixed-response</code>, you drop specified client requests
     * and return a custom HTTP response.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasActions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The actions. Each rule must include exactly one of the following types of actions: <code>forward</code>,
     *         <code>fixed-response</code>, or <code>redirect</code>, and it must be the last action to be
     *         performed.</p>
     *         <p>
     *         If the action type is <code>forward</code>, you specify one or more target groups. The protocol of the
     *         target group must be HTTP or HTTPS for an Application Load Balancer. The protocol of the target group
     *         must be TCP, TLS, UDP, or TCP_UDP for a Network Load Balancer.
     *         </p>
     *         <p>
     *         [HTTPS listeners] If the action type is <code>authenticate-oidc</code>, you authenticate users through an
     *         identity provider that is OpenID Connect (OIDC) compliant.
     *         </p>
     *         <p>
     *         [HTTPS listeners] If the action type is <code>authenticate-cognito</code>, you authenticate users through
     *         the user pools supported by Amazon Cognito.
     *         </p>
     *         <p>
     *         [Application Load Balancer] If the action type is <code>redirect</code>, you redirect specified client
     *         requests from one URL to another.
     *         </p>
     *         <p>
     *         [Application Load Balancer] If the action type is <code>fixed-response</code>, you drop specified client
     *         requests and return a custom HTTP response.
     */
    public List<Action> actions() {
        return actions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(listenerArn());
        hashCode = 31 * hashCode + Objects.hashCode(conditions());
        hashCode = 31 * hashCode + Objects.hashCode(priority());
        hashCode = 31 * hashCode + Objects.hashCode(actions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRuleRequest)) {
            return false;
        }
        CreateRuleRequest other = (CreateRuleRequest) obj;
        return Objects.equals(listenerArn(), other.listenerArn()) && Objects.equals(conditions(), other.conditions())
                && Objects.equals(priority(), other.priority()) && Objects.equals(actions(), other.actions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateRuleRequest").add("ListenerArn", listenerArn()).add("Conditions", conditions())
                .add("Priority", priority()).add("Actions", actions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ListenerArn":
            return Optional.ofNullable(clazz.cast(listenerArn()));
        case "Conditions":
            return Optional.ofNullable(clazz.cast(conditions()));
        case "Priority":
            return Optional.ofNullable(clazz.cast(priority()));
        case "Actions":
            return Optional.ofNullable(clazz.cast(actions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateRuleRequest, T> g) {
        return obj -> g.apply((CreateRuleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticLoadBalancingV2Request.Builder, SdkPojo, CopyableBuilder<Builder, CreateRuleRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the listener.
         * </p>
         * 
         * @param listenerArn
         *        The Amazon Resource Name (ARN) of the listener.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listenerArn(String listenerArn);

        /**
         * <p>
         * The conditions. Each rule can include zero or one of the following conditions:
         * <code>http-request-method</code>, <code>host-header</code>, <code>path-pattern</code>, and
         * <code>source-ip</code>, and zero or more of the following conditions: <code>http-header</code> and
         * <code>query-string</code>.
         * </p>
         * 
         * @param conditions
         *        The conditions. Each rule can include zero or one of the following conditions:
         *        <code>http-request-method</code>, <code>host-header</code>, <code>path-pattern</code>, and
         *        <code>source-ip</code>, and zero or more of the following conditions: <code>http-header</code> and
         *        <code>query-string</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conditions(Collection<RuleCondition> conditions);

        /**
         * <p>
         * The conditions. Each rule can include zero or one of the following conditions:
         * <code>http-request-method</code>, <code>host-header</code>, <code>path-pattern</code>, and
         * <code>source-ip</code>, and zero or more of the following conditions: <code>http-header</code> and
         * <code>query-string</code>.
         * </p>
         * 
         * @param conditions
         *        The conditions. Each rule can include zero or one of the following conditions:
         *        <code>http-request-method</code>, <code>host-header</code>, <code>path-pattern</code>, and
         *        <code>source-ip</code>, and zero or more of the following conditions: <code>http-header</code> and
         *        <code>query-string</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conditions(RuleCondition... conditions);

        /**
         * <p>
         * The conditions. Each rule can include zero or one of the following conditions:
         * <code>http-request-method</code>, <code>host-header</code>, <code>path-pattern</code>, and
         * <code>source-ip</code>, and zero or more of the following conditions: <code>http-header</code> and
         * <code>query-string</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RuleCondition>.Builder} avoiding the need
         * to create one manually via {@link List<RuleCondition>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RuleCondition>.Builder#build()} is called immediately and
         * its result is passed to {@link #conditions(List<RuleCondition>)}.
         * 
         * @param conditions
         *        a consumer that will call methods on {@link List<RuleCondition>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #conditions(List<RuleCondition>)
         */
        Builder conditions(Consumer<RuleCondition.Builder>... conditions);

        /**
         * <p>
         * The rule priority. A listener can't have multiple rules with the same priority.
         * </p>
         * 
         * @param priority
         *        The rule priority. A listener can't have multiple rules with the same priority.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priority(Integer priority);

        /**
         * <p>
         * The actions. Each rule must include exactly one of the following types of actions: <code>forward</code>,
         * <code>fixed-response</code>, or <code>redirect</code>, and it must be the last action to be performed.
         * </p>
         * <p>
         * If the action type is <code>forward</code>, you specify one or more target groups. The protocol of the target
         * group must be HTTP or HTTPS for an Application Load Balancer. The protocol of the target group must be TCP,
         * TLS, UDP, or TCP_UDP for a Network Load Balancer.
         * </p>
         * <p>
         * [HTTPS listeners] If the action type is <code>authenticate-oidc</code>, you authenticate users through an
         * identity provider that is OpenID Connect (OIDC) compliant.
         * </p>
         * <p>
         * [HTTPS listeners] If the action type is <code>authenticate-cognito</code>, you authenticate users through the
         * user pools supported by Amazon Cognito.
         * </p>
         * <p>
         * [Application Load Balancer] If the action type is <code>redirect</code>, you redirect specified client
         * requests from one URL to another.
         * </p>
         * <p>
         * [Application Load Balancer] If the action type is <code>fixed-response</code>, you drop specified client
         * requests and return a custom HTTP response.
         * </p>
         * 
         * @param actions
         *        The actions. Each rule must include exactly one of the following types of actions:
         *        <code>forward</code>, <code>fixed-response</code>, or <code>redirect</code>, and it must be the last
         *        action to be performed.</p>
         *        <p>
         *        If the action type is <code>forward</code>, you specify one or more target groups. The protocol of the
         *        target group must be HTTP or HTTPS for an Application Load Balancer. The protocol of the target group
         *        must be TCP, TLS, UDP, or TCP_UDP for a Network Load Balancer.
         *        </p>
         *        <p>
         *        [HTTPS listeners] If the action type is <code>authenticate-oidc</code>, you authenticate users through
         *        an identity provider that is OpenID Connect (OIDC) compliant.
         *        </p>
         *        <p>
         *        [HTTPS listeners] If the action type is <code>authenticate-cognito</code>, you authenticate users
         *        through the user pools supported by Amazon Cognito.
         *        </p>
         *        <p>
         *        [Application Load Balancer] If the action type is <code>redirect</code>, you redirect specified client
         *        requests from one URL to another.
         *        </p>
         *        <p>
         *        [Application Load Balancer] If the action type is <code>fixed-response</code>, you drop specified
         *        client requests and return a custom HTTP response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(Collection<Action> actions);

        /**
         * <p>
         * The actions. Each rule must include exactly one of the following types of actions: <code>forward</code>,
         * <code>fixed-response</code>, or <code>redirect</code>, and it must be the last action to be performed.
         * </p>
         * <p>
         * If the action type is <code>forward</code>, you specify one or more target groups. The protocol of the target
         * group must be HTTP or HTTPS for an Application Load Balancer. The protocol of the target group must be TCP,
         * TLS, UDP, or TCP_UDP for a Network Load Balancer.
         * </p>
         * <p>
         * [HTTPS listeners] If the action type is <code>authenticate-oidc</code>, you authenticate users through an
         * identity provider that is OpenID Connect (OIDC) compliant.
         * </p>
         * <p>
         * [HTTPS listeners] If the action type is <code>authenticate-cognito</code>, you authenticate users through the
         * user pools supported by Amazon Cognito.
         * </p>
         * <p>
         * [Application Load Balancer] If the action type is <code>redirect</code>, you redirect specified client
         * requests from one URL to another.
         * </p>
         * <p>
         * [Application Load Balancer] If the action type is <code>fixed-response</code>, you drop specified client
         * requests and return a custom HTTP response.
         * </p>
         * 
         * @param actions
         *        The actions. Each rule must include exactly one of the following types of actions:
         *        <code>forward</code>, <code>fixed-response</code>, or <code>redirect</code>, and it must be the last
         *        action to be performed.</p>
         *        <p>
         *        If the action type is <code>forward</code>, you specify one or more target groups. The protocol of the
         *        target group must be HTTP or HTTPS for an Application Load Balancer. The protocol of the target group
         *        must be TCP, TLS, UDP, or TCP_UDP for a Network Load Balancer.
         *        </p>
         *        <p>
         *        [HTTPS listeners] If the action type is <code>authenticate-oidc</code>, you authenticate users through
         *        an identity provider that is OpenID Connect (OIDC) compliant.
         *        </p>
         *        <p>
         *        [HTTPS listeners] If the action type is <code>authenticate-cognito</code>, you authenticate users
         *        through the user pools supported by Amazon Cognito.
         *        </p>
         *        <p>
         *        [Application Load Balancer] If the action type is <code>redirect</code>, you redirect specified client
         *        requests from one URL to another.
         *        </p>
         *        <p>
         *        [Application Load Balancer] If the action type is <code>fixed-response</code>, you drop specified
         *        client requests and return a custom HTTP response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(Action... actions);

        /**
         * <p>
         * The actions. Each rule must include exactly one of the following types of actions: <code>forward</code>,
         * <code>fixed-response</code>, or <code>redirect</code>, and it must be the last action to be performed.
         * </p>
         * <p>
         * If the action type is <code>forward</code>, you specify one or more target groups. The protocol of the target
         * group must be HTTP or HTTPS for an Application Load Balancer. The protocol of the target group must be TCP,
         * TLS, UDP, or TCP_UDP for a Network Load Balancer.
         * </p>
         * <p>
         * [HTTPS listeners] If the action type is <code>authenticate-oidc</code>, you authenticate users through an
         * identity provider that is OpenID Connect (OIDC) compliant.
         * </p>
         * <p>
         * [HTTPS listeners] If the action type is <code>authenticate-cognito</code>, you authenticate users through the
         * user pools supported by Amazon Cognito.
         * </p>
         * <p>
         * [Application Load Balancer] If the action type is <code>redirect</code>, you redirect specified client
         * requests from one URL to another.
         * </p>
         * <p>
         * [Application Load Balancer] If the action type is <code>fixed-response</code>, you drop specified client
         * requests and return a custom HTTP response.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Action>.Builder} avoiding the need to
         * create one manually via {@link List<Action>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Action>.Builder#build()} is called immediately and its
         * result is passed to {@link #actions(List<Action>)}.
         * 
         * @param actions
         *        a consumer that will call methods on {@link List<Action>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actions(List<Action>)
         */
        Builder actions(Consumer<Action.Builder>... actions);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElasticLoadBalancingV2Request.BuilderImpl implements Builder {
        private String listenerArn;

        private List<RuleCondition> conditions = DefaultSdkAutoConstructList.getInstance();

        private Integer priority;

        private List<Action> actions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRuleRequest model) {
            super(model);
            listenerArn(model.listenerArn);
            conditions(model.conditions);
            priority(model.priority);
            actions(model.actions);
        }

        public final String getListenerArn() {
            return listenerArn;
        }

        @Override
        public final Builder listenerArn(String listenerArn) {
            this.listenerArn = listenerArn;
            return this;
        }

        public final void setListenerArn(String listenerArn) {
            this.listenerArn = listenerArn;
        }

        public final Collection<RuleCondition.Builder> getConditions() {
            return conditions != null ? conditions.stream().map(RuleCondition::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder conditions(Collection<RuleCondition> conditions) {
            this.conditions = RuleConditionListCopier.copy(conditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conditions(RuleCondition... conditions) {
            conditions(Arrays.asList(conditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conditions(Consumer<RuleCondition.Builder>... conditions) {
            conditions(Stream.of(conditions).map(c -> RuleCondition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setConditions(Collection<RuleCondition.BuilderImpl> conditions) {
            this.conditions = RuleConditionListCopier.copyFromBuilder(conditions);
        }

        public final Integer getPriority() {
            return priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        public final Collection<Action.Builder> getActions() {
            return actions != null ? actions.stream().map(Action::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder actions(Collection<Action> actions) {
            this.actions = ActionsCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Action... actions) {
            actions(Arrays.asList(actions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Consumer<Action.Builder>... actions) {
            actions(Stream.of(actions).map(c -> Action.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setActions(Collection<Action.BuilderImpl> actions) {
            this.actions = ActionsCopier.copyFromBuilder(actions);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRuleRequest build() {
            return new CreateRuleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
