/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ElasticLoadBalancingV2Request;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RuleArnsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeRulesRequest
extends ElasticLoadBalancingV2Request
implements ToCopyableBuilder<Builder, DescribeRulesRequest> {
    private static final SdkField<String> LISTENER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeRulesRequest.getter(DescribeRulesRequest::listenerArn)).setter(DescribeRulesRequest.setter(Builder::listenerArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListenerArn").build()}).build();
    private static final SdkField<List<String>> RULE_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeRulesRequest.getter(DescribeRulesRequest::ruleArns)).setter(DescribeRulesRequest.setter(Builder::ruleArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeRulesRequest.getter(DescribeRulesRequest::marker)).setter(DescribeRulesRequest.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<Integer> PAGE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(DescribeRulesRequest.getter(DescribeRulesRequest::pageSize)).setter(DescribeRulesRequest.setter(Builder::pageSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageSize").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LISTENER_ARN_FIELD, RULE_ARNS_FIELD, MARKER_FIELD, PAGE_SIZE_FIELD));
    private final String listenerArn;
    private final List<String> ruleArns;
    private final String marker;
    private final Integer pageSize;

    private DescribeRulesRequest(BuilderImpl builder) {
        super(builder);
        this.listenerArn = builder.listenerArn;
        this.ruleArns = builder.ruleArns;
        this.marker = builder.marker;
        this.pageSize = builder.pageSize;
    }

    public String listenerArn() {
        return this.listenerArn;
    }

    public List<String> ruleArns() {
        return this.ruleArns;
    }

    public String marker() {
        return this.marker;
    }

    public Integer pageSize() {
        return this.pageSize;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.listenerArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleArns());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.pageSize());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRulesRequest)) {
            return false;
        }
        DescribeRulesRequest other = (DescribeRulesRequest)((Object)obj);
        return Objects.equals(this.listenerArn(), other.listenerArn()) && Objects.equals(this.ruleArns(), other.ruleArns()) && Objects.equals(this.marker(), other.marker()) && Objects.equals(this.pageSize(), other.pageSize());
    }

    public String toString() {
        return ToString.builder((String)"DescribeRulesRequest").add("ListenerArn", (Object)this.listenerArn()).add("RuleArns", this.ruleArns()).add("Marker", (Object)this.marker()).add("PageSize", (Object)this.pageSize()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ListenerArn": {
                return Optional.ofNullable(clazz.cast(this.listenerArn()));
            }
            case "RuleArns": {
                return Optional.ofNullable(clazz.cast(this.ruleArns()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "PageSize": {
                return Optional.ofNullable(clazz.cast(this.pageSize()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeRulesRequest, T> g) {
        return obj -> g.apply((DescribeRulesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticLoadBalancingV2Request.BuilderImpl
    implements Builder {
        private String listenerArn;
        private List<String> ruleArns = DefaultSdkAutoConstructList.getInstance();
        private String marker;
        private Integer pageSize;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRulesRequest model) {
            super(model);
            this.listenerArn(model.listenerArn);
            this.ruleArns(model.ruleArns);
            this.marker(model.marker);
            this.pageSize(model.pageSize);
        }

        public final String getListenerArn() {
            return this.listenerArn;
        }

        @Override
        public final Builder listenerArn(String listenerArn) {
            this.listenerArn = listenerArn;
            return this;
        }

        public final void setListenerArn(String listenerArn) {
            this.listenerArn = listenerArn;
        }

        public final Collection<String> getRuleArns() {
            return this.ruleArns;
        }

        @Override
        public final Builder ruleArns(Collection<String> ruleArns) {
            this.ruleArns = RuleArnsCopier.copy(ruleArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleArns(String ... ruleArns) {
            this.ruleArns(Arrays.asList(ruleArns));
            return this;
        }

        public final void setRuleArns(Collection<String> ruleArns) {
            this.ruleArns = RuleArnsCopier.copy(ruleArns);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Integer getPageSize() {
            return this.pageSize;
        }

        @Override
        public final Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public final void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeRulesRequest build() {
            return new DescribeRulesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElasticLoadBalancingV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeRulesRequest> {
        public Builder listenerArn(String var1);

        public Builder ruleArns(Collection<String> var1);

        public Builder ruleArns(String ... var1);

        public Builder marker(String var1);

        public Builder pageSize(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

