/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Matcher;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyTargetGroupRequest;

public class ModifyTargetGroupRequestMarshaller
implements Marshaller<Request<ModifyTargetGroupRequest>, ModifyTargetGroupRequest> {
    public Request<ModifyTargetGroupRequest> marshall(ModifyTargetGroupRequest modifyTargetGroupRequest) {
        Matcher matcher;
        if (modifyTargetGroupRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)modifyTargetGroupRequest, "ElasticLoadBalancingv2Client");
        request.addParameter("Action", "ModifyTargetGroup");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyTargetGroupRequest.targetGroupArn() != null) {
            request.addParameter("TargetGroupArn", StringUtils.fromString((String)modifyTargetGroupRequest.targetGroupArn()));
        }
        if (modifyTargetGroupRequest.healthCheckProtocolString() != null) {
            request.addParameter("HealthCheckProtocol", StringUtils.fromString((String)modifyTargetGroupRequest.healthCheckProtocolString()));
        }
        if (modifyTargetGroupRequest.healthCheckPort() != null) {
            request.addParameter("HealthCheckPort", StringUtils.fromString((String)modifyTargetGroupRequest.healthCheckPort()));
        }
        if (modifyTargetGroupRequest.healthCheckPath() != null) {
            request.addParameter("HealthCheckPath", StringUtils.fromString((String)modifyTargetGroupRequest.healthCheckPath()));
        }
        if (modifyTargetGroupRequest.healthCheckIntervalSeconds() != null) {
            request.addParameter("HealthCheckIntervalSeconds", StringUtils.fromInteger((Integer)modifyTargetGroupRequest.healthCheckIntervalSeconds()));
        }
        if (modifyTargetGroupRequest.healthCheckTimeoutSeconds() != null) {
            request.addParameter("HealthCheckTimeoutSeconds", StringUtils.fromInteger((Integer)modifyTargetGroupRequest.healthCheckTimeoutSeconds()));
        }
        if (modifyTargetGroupRequest.healthyThresholdCount() != null) {
            request.addParameter("HealthyThresholdCount", StringUtils.fromInteger((Integer)modifyTargetGroupRequest.healthyThresholdCount()));
        }
        if (modifyTargetGroupRequest.unhealthyThresholdCount() != null) {
            request.addParameter("UnhealthyThresholdCount", StringUtils.fromInteger((Integer)modifyTargetGroupRequest.unhealthyThresholdCount()));
        }
        if ((matcher = modifyTargetGroupRequest.matcher()) != null && matcher.httpCode() != null) {
            request.addParameter("Matcher.HttpCode", StringUtils.fromString((String)matcher.httpCode()));
        }
        return request;
    }
}

