/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.AddListenerCertificatesRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Certificate;

public class AddListenerCertificatesRequestMarshaller
implements Marshaller<Request<AddListenerCertificatesRequest>, AddListenerCertificatesRequest> {
    public Request<AddListenerCertificatesRequest> marshall(AddListenerCertificatesRequest addListenerCertificatesRequest) {
        List<Certificate> certificatesList;
        if (addListenerCertificatesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)addListenerCertificatesRequest, "ElasticLoadBalancingv2Client");
        request.addParameter("Action", "AddListenerCertificates");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (addListenerCertificatesRequest.listenerArn() != null) {
            request.addParameter("ListenerArn", StringUtils.fromString((String)addListenerCertificatesRequest.listenerArn()));
        }
        if ((certificatesList = addListenerCertificatesRequest.certificates()) != null) {
            if (!certificatesList.isEmpty()) {
                int certificatesListIndex = 1;
                for (Certificate certificatesListValue : certificatesList) {
                    if (certificatesListValue.certificateArn() != null) {
                        request.addParameter("Certificates.member." + certificatesListIndex + ".CertificateArn", StringUtils.fromString((String)certificatesListValue.certificateArn()));
                    }
                    if (certificatesListValue.isDefault() != null) {
                        request.addParameter("Certificates.member." + certificatesListIndex + ".IsDefault", StringUtils.fromBoolean((Boolean)certificatesListValue.isDefault()));
                    }
                    ++certificatesListIndex;
                }
            } else {
                request.addParameter("Certificates", "");
            }
        }
        return request;
    }
}

