/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.elasticloadbalancingv2.ElasticLoadBalancingv2Client;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenersRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenersResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Listener;

public final class DescribeListenersPaginator
implements SdkIterable<DescribeListenersResponse> {
    private final ElasticLoadBalancingv2Client client;
    private final DescribeListenersRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public DescribeListenersPaginator(ElasticLoadBalancingv2Client client, DescribeListenersRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeListenersResponseFetcher();
    }

    public Iterator<DescribeListenersResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<Listener> listeners() {
        Function<DescribeListenersResponse, Iterator> getIterator = response -> response != null ? response.listeners().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class DescribeListenersResponseFetcher
    implements NextPageFetcher<DescribeListenersResponse> {
        private DescribeListenersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeListenersResponse previousPage) {
            return previousPage.nextMarker() != null;
        }

        public DescribeListenersResponse nextPage(DescribeListenersResponse previousPage) {
            if (previousPage == null) {
                return DescribeListenersPaginator.this.client.describeListeners(DescribeListenersPaginator.this.firstRequest);
            }
            return DescribeListenersPaginator.this.client.describeListeners((DescribeListenersRequest)((Object)DescribeListenersPaginator.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

