/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ElasticLoadBalancingv2Response;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroupAttribute;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroupAttributesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ModifyTargetGroupAttributesResponse
extends ElasticLoadBalancingv2Response
implements ToCopyableBuilder<Builder, ModifyTargetGroupAttributesResponse> {
    private final List<TargetGroupAttribute> attributes;

    private ModifyTargetGroupAttributesResponse(BuilderImpl builder) {
        super(builder);
        this.attributes = builder.attributes;
    }

    public List<TargetGroupAttribute> attributes() {
        return this.attributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attributes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyTargetGroupAttributesResponse)) {
            return false;
        }
        ModifyTargetGroupAttributesResponse other = (ModifyTargetGroupAttributesResponse)((Object)obj);
        return Objects.equals(this.attributes(), other.attributes());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.attributes() != null) {
            sb.append("Attributes: ").append(this.attributes()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Attributes": {
                return Optional.of(clazz.cast(this.attributes()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElasticLoadBalancingv2Response.BuilderImpl
    implements Builder {
        private List<TargetGroupAttribute> attributes;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyTargetGroupAttributesResponse model) {
            this.attributes(model.attributes);
        }

        public final Collection<TargetGroupAttribute.Builder> getAttributes() {
            return this.attributes != null ? (Collection)this.attributes.stream().map(TargetGroupAttribute::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attributes(Collection<TargetGroupAttribute> attributes) {
            this.attributes = TargetGroupAttributesCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(TargetGroupAttribute ... attributes) {
            this.attributes(Arrays.asList(attributes));
            return this;
        }

        public final void setAttributes(Collection<TargetGroupAttribute.BuilderImpl> attributes) {
            this.attributes = TargetGroupAttributesCopier.copyFromBuilder(attributes);
        }

        @Override
        public ModifyTargetGroupAttributesResponse build() {
            return new ModifyTargetGroupAttributesResponse(this);
        }
    }

    public static interface Builder
    extends ElasticLoadBalancingv2Response.Builder,
    CopyableBuilder<Builder, ModifyTargetGroupAttributesResponse> {
        public Builder attributes(Collection<TargetGroupAttribute> var1);

        public Builder attributes(TargetGroupAttribute ... var1);
    }
}

