/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroupAttribute;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroupAttributesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeTargetGroupAttributesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeTargetGroupAttributesResponse> {
    private final List<TargetGroupAttribute> attributes;

    private DescribeTargetGroupAttributesResponse(BuilderImpl builder) {
        this.attributes = builder.attributes;
    }

    public List<TargetGroupAttribute> attributes() {
        return this.attributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.attributes() == null ? 0 : this.attributes().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTargetGroupAttributesResponse)) {
            return false;
        }
        DescribeTargetGroupAttributesResponse other = (DescribeTargetGroupAttributesResponse)((Object)obj);
        if (other.attributes() == null ^ this.attributes() == null) {
            return false;
        }
        return other.attributes() == null || other.attributes().equals(this.attributes());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.attributes() != null) {
            sb.append("Attributes: ").append(this.attributes()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<TargetGroupAttribute> attributes;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTargetGroupAttributesResponse model) {
            this.setAttributes(model.attributes);
        }

        public final Collection<TargetGroupAttribute> getAttributes() {
            return this.attributes;
        }

        @Override
        public final Builder attributes(Collection<TargetGroupAttribute> attributes) {
            this.attributes = TargetGroupAttributesCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(TargetGroupAttribute ... attributes) {
            this.attributes(Arrays.asList(attributes));
            return this;
        }

        public final void setAttributes(Collection<TargetGroupAttribute> attributes) {
            this.attributes = TargetGroupAttributesCopier.copy(attributes);
        }

        public DescribeTargetGroupAttributesResponse build() {
            return new DescribeTargetGroupAttributesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeTargetGroupAttributesResponse> {
        public Builder attributes(Collection<TargetGroupAttribute> var1);

        public Builder attributes(TargetGroupAttribute ... var1);
    }
}

