/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.waiters;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.services.elasticloadbalancingv2.ElasticLoadBalancingv2Client;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancersRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.waiters.DescribeLoadBalancersFunction;
import software.amazon.awssdk.services.elasticloadbalancingv2.waiters.LoadBalancerAvailable;
import software.amazon.awssdk.services.elasticloadbalancingv2.waiters.LoadBalancerExists;
import software.amazon.awssdk.services.elasticloadbalancingv2.waiters.LoadBalancersDeleted;
import software.amazon.awssdk.waiters.FixedDelayStrategy;
import software.amazon.awssdk.waiters.HttpSuccessStatusAcceptor;
import software.amazon.awssdk.waiters.MaxAttemptsRetryStrategy;
import software.amazon.awssdk.waiters.PollingStrategy;
import software.amazon.awssdk.waiters.SdkFunction;
import software.amazon.awssdk.waiters.Waiter;
import software.amazon.awssdk.waiters.WaiterAcceptor;
import software.amazon.awssdk.waiters.WaiterBuilder;
import software.amazon.awssdk.waiters.WaiterState;

public class ElasticLoadBalancingv2ClientWaiters {
    private final ElasticLoadBalancingv2Client client;
    private final ExecutorService executorService = Executors.newFixedThreadPool(50);

    @SdkInternalApi
    public ElasticLoadBalancingv2ClientWaiters(ElasticLoadBalancingv2Client client) {
        this.client = client;
    }

    public Waiter<DescribeLoadBalancersRequest> loadBalancerAvailable() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeLoadBalancersFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new LoadBalancerAvailable.IsActiveMatcher(), new LoadBalancerAvailable.IsProvisioningMatcher(), new LoadBalancerAvailable.IsLoadBalancerNotFoundMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeLoadBalancersRequest> loadBalancerExists() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeLoadBalancersFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new HttpSuccessStatusAcceptor(WaiterState.SUCCESS), new LoadBalancerExists.IsLoadBalancerNotFoundMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeLoadBalancersRequest> loadBalancersDeleted() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeLoadBalancersFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new LoadBalancersDeleted.IsActiveMatcher(), new LoadBalancersDeleted.IsLoadBalancerNotFoundMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }
}

