/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SubnetsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SetSubnetsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, SetSubnetsRequest> {
    private final String loadBalancerArn;
    private final List<String> subnets;

    private SetSubnetsRequest(BuilderImpl builder) {
        this.loadBalancerArn = builder.loadBalancerArn;
        this.subnets = builder.subnets;
    }

    public String loadBalancerArn() {
        return this.loadBalancerArn;
    }

    public List<String> subnets() {
        return this.subnets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.loadBalancerArn() == null ? 0 : this.loadBalancerArn().hashCode());
        hashCode = 31 * hashCode + (this.subnets() == null ? 0 : this.subnets().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetSubnetsRequest)) {
            return false;
        }
        SetSubnetsRequest other = (SetSubnetsRequest)((Object)obj);
        if (other.loadBalancerArn() == null ^ this.loadBalancerArn() == null) {
            return false;
        }
        if (other.loadBalancerArn() != null && !other.loadBalancerArn().equals(this.loadBalancerArn())) {
            return false;
        }
        if (other.subnets() == null ^ this.subnets() == null) {
            return false;
        }
        return other.subnets() == null || other.subnets().equals(this.subnets());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.loadBalancerArn() != null) {
            sb.append("LoadBalancerArn: ").append(this.loadBalancerArn()).append(",");
        }
        if (this.subnets() != null) {
            sb.append("Subnets: ").append(this.subnets()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String loadBalancerArn;
        private List<String> subnets;

        private BuilderImpl() {
        }

        private BuilderImpl(SetSubnetsRequest model) {
            this.setLoadBalancerArn(model.loadBalancerArn);
            this.setSubnets(model.subnets);
        }

        public final String getLoadBalancerArn() {
            return this.loadBalancerArn;
        }

        @Override
        public final Builder loadBalancerArn(String loadBalancerArn) {
            this.loadBalancerArn = loadBalancerArn;
            return this;
        }

        public final void setLoadBalancerArn(String loadBalancerArn) {
            this.loadBalancerArn = loadBalancerArn;
        }

        public final Collection<String> getSubnets() {
            return this.subnets;
        }

        @Override
        public final Builder subnets(Collection<String> subnets) {
            this.subnets = SubnetsCopier.copy(subnets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnets(String ... subnets) {
            this.subnets(Arrays.asList(subnets));
            return this;
        }

        public final void setSubnets(Collection<String> subnets) {
            this.subnets = SubnetsCopier.copy(subnets);
        }

        @SafeVarargs
        public final void setSubnets(String ... subnets) {
            this.subnets(Arrays.asList(subnets));
        }

        public SetSubnetsRequest build() {
            return new SetSubnetsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SetSubnetsRequest> {
        public Builder loadBalancerArn(String var1);

        public Builder subnets(Collection<String> var1);

        public Builder subnets(String ... var1);
    }
}

