/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetDescription;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetDescriptionsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RegisterTargetsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, RegisterTargetsRequest> {
    private final String targetGroupArn;
    private final List<TargetDescription> targets;

    private RegisterTargetsRequest(BuilderImpl builder) {
        this.targetGroupArn = builder.targetGroupArn;
        this.targets = builder.targets;
    }

    public String targetGroupArn() {
        return this.targetGroupArn;
    }

    public List<TargetDescription> targets() {
        return this.targets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.targetGroupArn() == null ? 0 : this.targetGroupArn().hashCode());
        hashCode = 31 * hashCode + (this.targets() == null ? 0 : this.targets().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterTargetsRequest)) {
            return false;
        }
        RegisterTargetsRequest other = (RegisterTargetsRequest)((Object)obj);
        if (other.targetGroupArn() == null ^ this.targetGroupArn() == null) {
            return false;
        }
        if (other.targetGroupArn() != null && !other.targetGroupArn().equals(this.targetGroupArn())) {
            return false;
        }
        if (other.targets() == null ^ this.targets() == null) {
            return false;
        }
        return other.targets() == null || other.targets().equals(this.targets());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.targetGroupArn() != null) {
            sb.append("TargetGroupArn: ").append(this.targetGroupArn()).append(",");
        }
        if (this.targets() != null) {
            sb.append("Targets: ").append(this.targets()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String targetGroupArn;
        private List<TargetDescription> targets;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterTargetsRequest model) {
            this.setTargetGroupArn(model.targetGroupArn);
            this.setTargets(model.targets);
        }

        public final String getTargetGroupArn() {
            return this.targetGroupArn;
        }

        @Override
        public final Builder targetGroupArn(String targetGroupArn) {
            this.targetGroupArn = targetGroupArn;
            return this;
        }

        public final void setTargetGroupArn(String targetGroupArn) {
            this.targetGroupArn = targetGroupArn;
        }

        public final Collection<TargetDescription> getTargets() {
            return this.targets;
        }

        @Override
        public final Builder targets(Collection<TargetDescription> targets) {
            this.targets = TargetDescriptionsCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(TargetDescription ... targets) {
            this.targets(Arrays.asList(targets));
            return this;
        }

        public final void setTargets(Collection<TargetDescription> targets) {
            this.targets = TargetDescriptionsCopier.copy(targets);
        }

        @SafeVarargs
        public final void setTargets(TargetDescription ... targets) {
            this.targets(Arrays.asList(targets));
        }

        public RegisterTargetsRequest build() {
            return new RegisterTargetsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RegisterTargetsRequest> {
        public Builder targetGroupArn(String var1);

        public Builder targets(Collection<TargetDescription> var1);

        public Builder targets(TargetDescription ... var1);
    }
}

