/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerStateEnum;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class LoadBalancerState
implements ToCopyableBuilder<Builder, LoadBalancerState> {
    private final String code;
    private final String reason;

    private LoadBalancerState(BuilderImpl builder) {
        this.code = builder.code;
        this.reason = builder.reason;
    }

    public String code() {
        return this.code;
    }

    public String reason() {
        return this.reason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.code() == null ? 0 : this.code().hashCode());
        hashCode = 31 * hashCode + (this.reason() == null ? 0 : this.reason().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoadBalancerState)) {
            return false;
        }
        LoadBalancerState other = (LoadBalancerState)obj;
        if (other.code() == null ^ this.code() == null) {
            return false;
        }
        if (other.code() != null && !other.code().equals(this.code())) {
            return false;
        }
        if (other.reason() == null ^ this.reason() == null) {
            return false;
        }
        return other.reason() == null || other.reason().equals(this.reason());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.code() != null) {
            sb.append("Code: ").append(this.code()).append(",");
        }
        if (this.reason() != null) {
            sb.append("Reason: ").append(this.reason()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String code;
        private String reason;

        private BuilderImpl() {
        }

        private BuilderImpl(LoadBalancerState model) {
            this.setCode(model.code);
            this.setReason(model.reason);
        }

        public final String getCode() {
            return this.code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        @Override
        public final Builder code(LoadBalancerStateEnum code) {
            this.code(code.toString());
            return this;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        public final void setCode(LoadBalancerStateEnum code) {
            this.code(code.toString());
        }

        public final String getReason() {
            return this.reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        public LoadBalancerState build() {
            return new LoadBalancerState(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, LoadBalancerState> {
        public Builder code(String var1);

        public Builder code(LoadBalancerStateEnum var1);

        public Builder reason(String var1);
    }
}

