/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ListenerArnsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeListenersRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeListenersRequest> {
    private final String loadBalancerArn;
    private final List<String> listenerArns;
    private final String marker;
    private final Integer pageSize;

    private DescribeListenersRequest(BuilderImpl builder) {
        this.loadBalancerArn = builder.loadBalancerArn;
        this.listenerArns = builder.listenerArns;
        this.marker = builder.marker;
        this.pageSize = builder.pageSize;
    }

    public String loadBalancerArn() {
        return this.loadBalancerArn;
    }

    public List<String> listenerArns() {
        return this.listenerArns;
    }

    public String marker() {
        return this.marker;
    }

    public Integer pageSize() {
        return this.pageSize;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.loadBalancerArn() == null ? 0 : this.loadBalancerArn().hashCode());
        hashCode = 31 * hashCode + (this.listenerArns() == null ? 0 : this.listenerArns().hashCode());
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        hashCode = 31 * hashCode + (this.pageSize() == null ? 0 : this.pageSize().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeListenersRequest)) {
            return false;
        }
        DescribeListenersRequest other = (DescribeListenersRequest)((Object)obj);
        if (other.loadBalancerArn() == null ^ this.loadBalancerArn() == null) {
            return false;
        }
        if (other.loadBalancerArn() != null && !other.loadBalancerArn().equals(this.loadBalancerArn())) {
            return false;
        }
        if (other.listenerArns() == null ^ this.listenerArns() == null) {
            return false;
        }
        if (other.listenerArns() != null && !other.listenerArns().equals(this.listenerArns())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        if (other.marker() != null && !other.marker().equals(this.marker())) {
            return false;
        }
        if (other.pageSize() == null ^ this.pageSize() == null) {
            return false;
        }
        return other.pageSize() == null || other.pageSize().equals(this.pageSize());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.loadBalancerArn() != null) {
            sb.append("LoadBalancerArn: ").append(this.loadBalancerArn()).append(",");
        }
        if (this.listenerArns() != null) {
            sb.append("ListenerArns: ").append(this.listenerArns()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (this.pageSize() != null) {
            sb.append("PageSize: ").append(this.pageSize()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String loadBalancerArn;
        private List<String> listenerArns;
        private String marker;
        private Integer pageSize;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeListenersRequest model) {
            this.setLoadBalancerArn(model.loadBalancerArn);
            this.setListenerArns(model.listenerArns);
            this.setMarker(model.marker);
            this.setPageSize(model.pageSize);
        }

        public final String getLoadBalancerArn() {
            return this.loadBalancerArn;
        }

        @Override
        public final Builder loadBalancerArn(String loadBalancerArn) {
            this.loadBalancerArn = loadBalancerArn;
            return this;
        }

        public final void setLoadBalancerArn(String loadBalancerArn) {
            this.loadBalancerArn = loadBalancerArn;
        }

        public final Collection<String> getListenerArns() {
            return this.listenerArns;
        }

        @Override
        public final Builder listenerArns(Collection<String> listenerArns) {
            this.listenerArns = ListenerArnsCopier.copy(listenerArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listenerArns(String ... listenerArns) {
            this.listenerArns(Arrays.asList(listenerArns));
            return this;
        }

        public final void setListenerArns(Collection<String> listenerArns) {
            this.listenerArns = ListenerArnsCopier.copy(listenerArns);
        }

        @SafeVarargs
        public final void setListenerArns(String ... listenerArns) {
            this.listenerArns(Arrays.asList(listenerArns));
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Integer getPageSize() {
            return this.pageSize;
        }

        @Override
        public final Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public final void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        public DescribeListenersRequest build() {
            return new DescribeListenersRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeListenersRequest> {
        public Builder loadBalancerArn(String var1);

        public Builder listenerArns(Collection<String> var1);

        public Builder listenerArns(String ... var1);

        public Builder marker(String var1);

        public Builder pageSize(Integer var1);
    }
}

