/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancer;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancersCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateLoadBalancerResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, CreateLoadBalancerResponse> {
    private final List<LoadBalancer> loadBalancers;

    private CreateLoadBalancerResponse(BuilderImpl builder) {
        this.loadBalancers = builder.loadBalancers;
    }

    public List<LoadBalancer> loadBalancers() {
        return this.loadBalancers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.loadBalancers() == null ? 0 : this.loadBalancers().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLoadBalancerResponse)) {
            return false;
        }
        CreateLoadBalancerResponse other = (CreateLoadBalancerResponse)((Object)obj);
        if (other.loadBalancers() == null ^ this.loadBalancers() == null) {
            return false;
        }
        return other.loadBalancers() == null || other.loadBalancers().equals(this.loadBalancers());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.loadBalancers() != null) {
            sb.append("LoadBalancers: ").append(this.loadBalancers()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<LoadBalancer> loadBalancers;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLoadBalancerResponse model) {
            this.setLoadBalancers(model.loadBalancers);
        }

        public final Collection<LoadBalancer> getLoadBalancers() {
            return this.loadBalancers;
        }

        @Override
        public final Builder loadBalancers(Collection<LoadBalancer> loadBalancers) {
            this.loadBalancers = LoadBalancersCopier.copy(loadBalancers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancers(LoadBalancer ... loadBalancers) {
            this.loadBalancers(Arrays.asList(loadBalancers));
            return this;
        }

        public final void setLoadBalancers(Collection<LoadBalancer> loadBalancers) {
            this.loadBalancers = LoadBalancersCopier.copy(loadBalancers);
        }

        @SafeVarargs
        public final void setLoadBalancers(LoadBalancer ... loadBalancers) {
            this.loadBalancers(Arrays.asList(loadBalancers));
        }

        public CreateLoadBalancerResponse build() {
            return new CreateLoadBalancerResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateLoadBalancerResponse> {
        public Builder loadBalancers(Collection<LoadBalancer> var1);

        public Builder loadBalancers(LoadBalancer ... var1);
    }
}

