/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticloadbalancing.model.AvailabilityZonesCopier;
import software.amazon.awssdk.services.elasticloadbalancing.model.BackendServerDescription;
import software.amazon.awssdk.services.elasticloadbalancing.model.BackendServerDescriptionsCopier;
import software.amazon.awssdk.services.elasticloadbalancing.model.HealthCheck;
import software.amazon.awssdk.services.elasticloadbalancing.model.Instance;
import software.amazon.awssdk.services.elasticloadbalancing.model.InstancesCopier;
import software.amazon.awssdk.services.elasticloadbalancing.model.ListenerDescription;
import software.amazon.awssdk.services.elasticloadbalancing.model.ListenerDescriptionsCopier;
import software.amazon.awssdk.services.elasticloadbalancing.model.Policies;
import software.amazon.awssdk.services.elasticloadbalancing.model.SecurityGroupsCopier;
import software.amazon.awssdk.services.elasticloadbalancing.model.SourceSecurityGroup;
import software.amazon.awssdk.services.elasticloadbalancing.model.SubnetsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LoadBalancerDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LoadBalancerDescription> {
    private static final SdkField<String> LOAD_BALANCER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LoadBalancerName").getter(LoadBalancerDescription.getter(LoadBalancerDescription::loadBalancerName)).setter(LoadBalancerDescription.setter(Builder::loadBalancerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerName").build()}).build();
    private static final SdkField<String> DNS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DNSName").getter(LoadBalancerDescription.getter(LoadBalancerDescription::dnsName)).setter(LoadBalancerDescription.setter(Builder::dnsName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DNSName").build()}).build();
    private static final SdkField<String> CANONICAL_HOSTED_ZONE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CanonicalHostedZoneName").getter(LoadBalancerDescription.getter(LoadBalancerDescription::canonicalHostedZoneName)).setter(LoadBalancerDescription.setter(Builder::canonicalHostedZoneName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CanonicalHostedZoneName").build()}).build();
    private static final SdkField<String> CANONICAL_HOSTED_ZONE_NAME_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CanonicalHostedZoneNameID").getter(LoadBalancerDescription.getter(LoadBalancerDescription::canonicalHostedZoneNameID)).setter(LoadBalancerDescription.setter(Builder::canonicalHostedZoneNameID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CanonicalHostedZoneNameID").build()}).build();
    private static final SdkField<List<ListenerDescription>> LISTENER_DESCRIPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ListenerDescriptions").getter(LoadBalancerDescription.getter(LoadBalancerDescription::listenerDescriptions)).setter(LoadBalancerDescription.setter(Builder::listenerDescriptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListenerDescriptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ListenerDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Policies> POLICIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Policies").getter(LoadBalancerDescription.getter(LoadBalancerDescription::policies)).setter(LoadBalancerDescription.setter(Builder::policies)).constructor(Policies::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Policies").build()}).build();
    private static final SdkField<List<BackendServerDescription>> BACKEND_SERVER_DESCRIPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BackendServerDescriptions").getter(LoadBalancerDescription.getter(LoadBalancerDescription::backendServerDescriptions)).setter(LoadBalancerDescription.setter(Builder::backendServerDescriptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackendServerDescriptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BackendServerDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> AVAILABILITY_ZONES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AvailabilityZones").getter(LoadBalancerDescription.getter(LoadBalancerDescription::availabilityZones)).setter(LoadBalancerDescription.setter(Builder::availabilityZones)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZones").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SUBNETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Subnets").getter(LoadBalancerDescription.getter(LoadBalancerDescription::subnets)).setter(LoadBalancerDescription.setter(Builder::subnets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subnets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VPCId").getter(LoadBalancerDescription.getter(LoadBalancerDescription::vpcId)).setter(LoadBalancerDescription.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VPCId").build()}).build();
    private static final SdkField<List<Instance>> INSTANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Instances").getter(LoadBalancerDescription.getter(LoadBalancerDescription::instances)).setter(LoadBalancerDescription.setter(Builder::instances)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Instances").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Instance::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<HealthCheck> HEALTH_CHECK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HealthCheck").getter(LoadBalancerDescription.getter(LoadBalancerDescription::healthCheck)).setter(LoadBalancerDescription.setter(Builder::healthCheck)).constructor(HealthCheck::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheck").build()}).build();
    private static final SdkField<SourceSecurityGroup> SOURCE_SECURITY_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SourceSecurityGroup").getter(LoadBalancerDescription.getter(LoadBalancerDescription::sourceSecurityGroup)).setter(LoadBalancerDescription.setter(Builder::sourceSecurityGroup)).constructor(SourceSecurityGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceSecurityGroup").build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroups").getter(LoadBalancerDescription.getter(LoadBalancerDescription::securityGroups)).setter(LoadBalancerDescription.setter(Builder::securityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(LoadBalancerDescription.getter(LoadBalancerDescription::createdTime)).setter(LoadBalancerDescription.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<String> SCHEME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Scheme").getter(LoadBalancerDescription.getter(LoadBalancerDescription::scheme)).setter(LoadBalancerDescription.setter(Builder::scheme)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scheme").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOAD_BALANCER_NAME_FIELD, DNS_NAME_FIELD, CANONICAL_HOSTED_ZONE_NAME_FIELD, CANONICAL_HOSTED_ZONE_NAME_ID_FIELD, LISTENER_DESCRIPTIONS_FIELD, POLICIES_FIELD, BACKEND_SERVER_DESCRIPTIONS_FIELD, AVAILABILITY_ZONES_FIELD, SUBNETS_FIELD, VPC_ID_FIELD, INSTANCES_FIELD, HEALTH_CHECK_FIELD, SOURCE_SECURITY_GROUP_FIELD, SECURITY_GROUPS_FIELD, CREATED_TIME_FIELD, SCHEME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LoadBalancerDescription.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String loadBalancerName;
    private final String dnsName;
    private final String canonicalHostedZoneName;
    private final String canonicalHostedZoneNameID;
    private final List<ListenerDescription> listenerDescriptions;
    private final Policies policies;
    private final List<BackendServerDescription> backendServerDescriptions;
    private final List<String> availabilityZones;
    private final List<String> subnets;
    private final String vpcId;
    private final List<Instance> instances;
    private final HealthCheck healthCheck;
    private final SourceSecurityGroup sourceSecurityGroup;
    private final List<String> securityGroups;
    private final Instant createdTime;
    private final String scheme;

    private LoadBalancerDescription(BuilderImpl builder) {
        this.loadBalancerName = builder.loadBalancerName;
        this.dnsName = builder.dnsName;
        this.canonicalHostedZoneName = builder.canonicalHostedZoneName;
        this.canonicalHostedZoneNameID = builder.canonicalHostedZoneNameID;
        this.listenerDescriptions = builder.listenerDescriptions;
        this.policies = builder.policies;
        this.backendServerDescriptions = builder.backendServerDescriptions;
        this.availabilityZones = builder.availabilityZones;
        this.subnets = builder.subnets;
        this.vpcId = builder.vpcId;
        this.instances = builder.instances;
        this.healthCheck = builder.healthCheck;
        this.sourceSecurityGroup = builder.sourceSecurityGroup;
        this.securityGroups = builder.securityGroups;
        this.createdTime = builder.createdTime;
        this.scheme = builder.scheme;
    }

    public final String loadBalancerName() {
        return this.loadBalancerName;
    }

    public final String dnsName() {
        return this.dnsName;
    }

    public final String canonicalHostedZoneName() {
        return this.canonicalHostedZoneName;
    }

    public final String canonicalHostedZoneNameID() {
        return this.canonicalHostedZoneNameID;
    }

    public final boolean hasListenerDescriptions() {
        return this.listenerDescriptions != null && !(this.listenerDescriptions instanceof SdkAutoConstructList);
    }

    public final List<ListenerDescription> listenerDescriptions() {
        return this.listenerDescriptions;
    }

    public final Policies policies() {
        return this.policies;
    }

    public final boolean hasBackendServerDescriptions() {
        return this.backendServerDescriptions != null && !(this.backendServerDescriptions instanceof SdkAutoConstructList);
    }

    public final List<BackendServerDescription> backendServerDescriptions() {
        return this.backendServerDescriptions;
    }

    public final boolean hasAvailabilityZones() {
        return this.availabilityZones != null && !(this.availabilityZones instanceof SdkAutoConstructList);
    }

    public final List<String> availabilityZones() {
        return this.availabilityZones;
    }

    public final boolean hasSubnets() {
        return this.subnets != null && !(this.subnets instanceof SdkAutoConstructList);
    }

    public final List<String> subnets() {
        return this.subnets;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public final boolean hasInstances() {
        return this.instances != null && !(this.instances instanceof SdkAutoConstructList);
    }

    public final List<Instance> instances() {
        return this.instances;
    }

    public final HealthCheck healthCheck() {
        return this.healthCheck;
    }

    public final SourceSecurityGroup sourceSecurityGroup() {
        return this.sourceSecurityGroup;
    }

    public final boolean hasSecurityGroups() {
        return this.securityGroups != null && !(this.securityGroups instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroups() {
        return this.securityGroups;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final String scheme() {
        return this.scheme;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.loadBalancerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsName());
        hashCode = 31 * hashCode + Objects.hashCode(this.canonicalHostedZoneName());
        hashCode = 31 * hashCode + Objects.hashCode(this.canonicalHostedZoneNameID());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasListenerDescriptions() ? this.listenerDescriptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.policies());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBackendServerDescriptions() ? this.backendServerDescriptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAvailabilityZones() ? this.availabilityZones() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubnets() ? this.subnets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstances() ? this.instances() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheck());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceSecurityGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroups() ? this.securityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheme());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoadBalancerDescription)) {
            return false;
        }
        LoadBalancerDescription other = (LoadBalancerDescription)obj;
        return Objects.equals(this.loadBalancerName(), other.loadBalancerName()) && Objects.equals(this.dnsName(), other.dnsName()) && Objects.equals(this.canonicalHostedZoneName(), other.canonicalHostedZoneName()) && Objects.equals(this.canonicalHostedZoneNameID(), other.canonicalHostedZoneNameID()) && this.hasListenerDescriptions() == other.hasListenerDescriptions() && Objects.equals(this.listenerDescriptions(), other.listenerDescriptions()) && Objects.equals(this.policies(), other.policies()) && this.hasBackendServerDescriptions() == other.hasBackendServerDescriptions() && Objects.equals(this.backendServerDescriptions(), other.backendServerDescriptions()) && this.hasAvailabilityZones() == other.hasAvailabilityZones() && Objects.equals(this.availabilityZones(), other.availabilityZones()) && this.hasSubnets() == other.hasSubnets() && Objects.equals(this.subnets(), other.subnets()) && Objects.equals(this.vpcId(), other.vpcId()) && this.hasInstances() == other.hasInstances() && Objects.equals(this.instances(), other.instances()) && Objects.equals(this.healthCheck(), other.healthCheck()) && Objects.equals(this.sourceSecurityGroup(), other.sourceSecurityGroup()) && this.hasSecurityGroups() == other.hasSecurityGroups() && Objects.equals(this.securityGroups(), other.securityGroups()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.scheme(), other.scheme());
    }

    public final String toString() {
        return ToString.builder((String)"LoadBalancerDescription").add("LoadBalancerName", (Object)this.loadBalancerName()).add("DNSName", (Object)this.dnsName()).add("CanonicalHostedZoneName", (Object)this.canonicalHostedZoneName()).add("CanonicalHostedZoneNameID", (Object)this.canonicalHostedZoneNameID()).add("ListenerDescriptions", this.hasListenerDescriptions() ? this.listenerDescriptions() : null).add("Policies", (Object)this.policies()).add("BackendServerDescriptions", this.hasBackendServerDescriptions() ? this.backendServerDescriptions() : null).add("AvailabilityZones", this.hasAvailabilityZones() ? this.availabilityZones() : null).add("Subnets", this.hasSubnets() ? this.subnets() : null).add("VPCId", (Object)this.vpcId()).add("Instances", this.hasInstances() ? this.instances() : null).add("HealthCheck", (Object)this.healthCheck()).add("SourceSecurityGroup", (Object)this.sourceSecurityGroup()).add("SecurityGroups", this.hasSecurityGroups() ? this.securityGroups() : null).add("CreatedTime", (Object)this.createdTime()).add("Scheme", (Object)this.scheme()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LoadBalancerName": {
                return Optional.ofNullable(clazz.cast(this.loadBalancerName()));
            }
            case "DNSName": {
                return Optional.ofNullable(clazz.cast(this.dnsName()));
            }
            case "CanonicalHostedZoneName": {
                return Optional.ofNullable(clazz.cast(this.canonicalHostedZoneName()));
            }
            case "CanonicalHostedZoneNameID": {
                return Optional.ofNullable(clazz.cast(this.canonicalHostedZoneNameID()));
            }
            case "ListenerDescriptions": {
                return Optional.ofNullable(clazz.cast(this.listenerDescriptions()));
            }
            case "Policies": {
                return Optional.ofNullable(clazz.cast(this.policies()));
            }
            case "BackendServerDescriptions": {
                return Optional.ofNullable(clazz.cast(this.backendServerDescriptions()));
            }
            case "AvailabilityZones": {
                return Optional.ofNullable(clazz.cast(this.availabilityZones()));
            }
            case "Subnets": {
                return Optional.ofNullable(clazz.cast(this.subnets()));
            }
            case "VPCId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "Instances": {
                return Optional.ofNullable(clazz.cast(this.instances()));
            }
            case "HealthCheck": {
                return Optional.ofNullable(clazz.cast(this.healthCheck()));
            }
            case "SourceSecurityGroup": {
                return Optional.ofNullable(clazz.cast(this.sourceSecurityGroup()));
            }
            case "SecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.securityGroups()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "Scheme": {
                return Optional.ofNullable(clazz.cast(this.scheme()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("LoadBalancerName", LOAD_BALANCER_NAME_FIELD);
        map.put("DNSName", DNS_NAME_FIELD);
        map.put("CanonicalHostedZoneName", CANONICAL_HOSTED_ZONE_NAME_FIELD);
        map.put("CanonicalHostedZoneNameID", CANONICAL_HOSTED_ZONE_NAME_ID_FIELD);
        map.put("ListenerDescriptions", LISTENER_DESCRIPTIONS_FIELD);
        map.put("Policies", POLICIES_FIELD);
        map.put("BackendServerDescriptions", BACKEND_SERVER_DESCRIPTIONS_FIELD);
        map.put("AvailabilityZones", AVAILABILITY_ZONES_FIELD);
        map.put("Subnets", SUBNETS_FIELD);
        map.put("VPCId", VPC_ID_FIELD);
        map.put("Instances", INSTANCES_FIELD);
        map.put("HealthCheck", HEALTH_CHECK_FIELD);
        map.put("SourceSecurityGroup", SOURCE_SECURITY_GROUP_FIELD);
        map.put("SecurityGroups", SECURITY_GROUPS_FIELD);
        map.put("CreatedTime", CREATED_TIME_FIELD);
        map.put("Scheme", SCHEME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LoadBalancerDescription, T> g) {
        return obj -> g.apply((LoadBalancerDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String loadBalancerName;
        private String dnsName;
        private String canonicalHostedZoneName;
        private String canonicalHostedZoneNameID;
        private List<ListenerDescription> listenerDescriptions = DefaultSdkAutoConstructList.getInstance();
        private Policies policies;
        private List<BackendServerDescription> backendServerDescriptions = DefaultSdkAutoConstructList.getInstance();
        private List<String> availabilityZones = DefaultSdkAutoConstructList.getInstance();
        private List<String> subnets = DefaultSdkAutoConstructList.getInstance();
        private String vpcId;
        private List<Instance> instances = DefaultSdkAutoConstructList.getInstance();
        private HealthCheck healthCheck;
        private SourceSecurityGroup sourceSecurityGroup;
        private List<String> securityGroups = DefaultSdkAutoConstructList.getInstance();
        private Instant createdTime;
        private String scheme;

        private BuilderImpl() {
        }

        private BuilderImpl(LoadBalancerDescription model) {
            this.loadBalancerName(model.loadBalancerName);
            this.dnsName(model.dnsName);
            this.canonicalHostedZoneName(model.canonicalHostedZoneName);
            this.canonicalHostedZoneNameID(model.canonicalHostedZoneNameID);
            this.listenerDescriptions(model.listenerDescriptions);
            this.policies(model.policies);
            this.backendServerDescriptions(model.backendServerDescriptions);
            this.availabilityZones(model.availabilityZones);
            this.subnets(model.subnets);
            this.vpcId(model.vpcId);
            this.instances(model.instances);
            this.healthCheck(model.healthCheck);
            this.sourceSecurityGroup(model.sourceSecurityGroup);
            this.securityGroups(model.securityGroups);
            this.createdTime(model.createdTime);
            this.scheme(model.scheme);
        }

        public final String getLoadBalancerName() {
            return this.loadBalancerName;
        }

        public final void setLoadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
        }

        @Override
        public final Builder loadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
            return this;
        }

        public final String getDnsName() {
            return this.dnsName;
        }

        public final void setDnsName(String dnsName) {
            this.dnsName = dnsName;
        }

        @Override
        public final Builder dnsName(String dnsName) {
            this.dnsName = dnsName;
            return this;
        }

        public final String getCanonicalHostedZoneName() {
            return this.canonicalHostedZoneName;
        }

        public final void setCanonicalHostedZoneName(String canonicalHostedZoneName) {
            this.canonicalHostedZoneName = canonicalHostedZoneName;
        }

        @Override
        public final Builder canonicalHostedZoneName(String canonicalHostedZoneName) {
            this.canonicalHostedZoneName = canonicalHostedZoneName;
            return this;
        }

        public final String getCanonicalHostedZoneNameID() {
            return this.canonicalHostedZoneNameID;
        }

        public final void setCanonicalHostedZoneNameID(String canonicalHostedZoneNameID) {
            this.canonicalHostedZoneNameID = canonicalHostedZoneNameID;
        }

        @Override
        public final Builder canonicalHostedZoneNameID(String canonicalHostedZoneNameID) {
            this.canonicalHostedZoneNameID = canonicalHostedZoneNameID;
            return this;
        }

        public final List<ListenerDescription.Builder> getListenerDescriptions() {
            List<ListenerDescription.Builder> result = ListenerDescriptionsCopier.copyToBuilder(this.listenerDescriptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setListenerDescriptions(Collection<ListenerDescription.BuilderImpl> listenerDescriptions) {
            this.listenerDescriptions = ListenerDescriptionsCopier.copyFromBuilder(listenerDescriptions);
        }

        @Override
        public final Builder listenerDescriptions(Collection<ListenerDescription> listenerDescriptions) {
            this.listenerDescriptions = ListenerDescriptionsCopier.copy(listenerDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listenerDescriptions(ListenerDescription ... listenerDescriptions) {
            this.listenerDescriptions(Arrays.asList(listenerDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listenerDescriptions(Consumer<ListenerDescription.Builder> ... listenerDescriptions) {
            this.listenerDescriptions(Stream.of(listenerDescriptions).map(c -> (ListenerDescription)((ListenerDescription.Builder)ListenerDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Policies.Builder getPolicies() {
            return this.policies != null ? this.policies.toBuilder() : null;
        }

        public final void setPolicies(Policies.BuilderImpl policies) {
            this.policies = policies != null ? policies.build() : null;
        }

        @Override
        public final Builder policies(Policies policies) {
            this.policies = policies;
            return this;
        }

        public final List<BackendServerDescription.Builder> getBackendServerDescriptions() {
            List<BackendServerDescription.Builder> result = BackendServerDescriptionsCopier.copyToBuilder(this.backendServerDescriptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBackendServerDescriptions(Collection<BackendServerDescription.BuilderImpl> backendServerDescriptions) {
            this.backendServerDescriptions = BackendServerDescriptionsCopier.copyFromBuilder(backendServerDescriptions);
        }

        @Override
        public final Builder backendServerDescriptions(Collection<BackendServerDescription> backendServerDescriptions) {
            this.backendServerDescriptions = BackendServerDescriptionsCopier.copy(backendServerDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder backendServerDescriptions(BackendServerDescription ... backendServerDescriptions) {
            this.backendServerDescriptions(Arrays.asList(backendServerDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder backendServerDescriptions(Consumer<BackendServerDescription.Builder> ... backendServerDescriptions) {
            this.backendServerDescriptions(Stream.of(backendServerDescriptions).map(c -> (BackendServerDescription)((BackendServerDescription.Builder)BackendServerDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getAvailabilityZones() {
            if (this.availabilityZones instanceof SdkAutoConstructList) {
                return null;
            }
            return this.availabilityZones;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String ... availabilityZones) {
            this.availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final Collection<String> getSubnets() {
            if (this.subnets instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subnets;
        }

        public final void setSubnets(Collection<String> subnets) {
            this.subnets = SubnetsCopier.copy(subnets);
        }

        @Override
        public final Builder subnets(Collection<String> subnets) {
            this.subnets = SubnetsCopier.copy(subnets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnets(String ... subnets) {
            this.subnets(Arrays.asList(subnets));
            return this;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final List<Instance.Builder> getInstances() {
            List<Instance.Builder> result = InstancesCopier.copyToBuilder(this.instances);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstances(Collection<Instance.BuilderImpl> instances) {
            this.instances = InstancesCopier.copyFromBuilder(instances);
        }

        @Override
        public final Builder instances(Collection<Instance> instances) {
            this.instances = InstancesCopier.copy(instances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(Instance ... instances) {
            this.instances(Arrays.asList(instances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(Consumer<Instance.Builder> ... instances) {
            this.instances(Stream.of(instances).map(c -> (Instance)((Instance.Builder)Instance.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final HealthCheck.Builder getHealthCheck() {
            return this.healthCheck != null ? this.healthCheck.toBuilder() : null;
        }

        public final void setHealthCheck(HealthCheck.BuilderImpl healthCheck) {
            this.healthCheck = healthCheck != null ? healthCheck.build() : null;
        }

        @Override
        public final Builder healthCheck(HealthCheck healthCheck) {
            this.healthCheck = healthCheck;
            return this;
        }

        public final SourceSecurityGroup.Builder getSourceSecurityGroup() {
            return this.sourceSecurityGroup != null ? this.sourceSecurityGroup.toBuilder() : null;
        }

        public final void setSourceSecurityGroup(SourceSecurityGroup.BuilderImpl sourceSecurityGroup) {
            this.sourceSecurityGroup = sourceSecurityGroup != null ? sourceSecurityGroup.build() : null;
        }

        @Override
        public final Builder sourceSecurityGroup(SourceSecurityGroup sourceSecurityGroup) {
            this.sourceSecurityGroup = sourceSecurityGroup;
            return this;
        }

        public final Collection<String> getSecurityGroups() {
            if (this.securityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroups;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupsCopier.copy(securityGroups);
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupsCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String ... securityGroups) {
            this.securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getScheme() {
            return this.scheme;
        }

        public final void setScheme(String scheme) {
            this.scheme = scheme;
        }

        @Override
        public final Builder scheme(String scheme) {
            this.scheme = scheme;
            return this;
        }

        public LoadBalancerDescription build() {
            return new LoadBalancerDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LoadBalancerDescription> {
        public Builder loadBalancerName(String var1);

        public Builder dnsName(String var1);

        public Builder canonicalHostedZoneName(String var1);

        public Builder canonicalHostedZoneNameID(String var1);

        public Builder listenerDescriptions(Collection<ListenerDescription> var1);

        public Builder listenerDescriptions(ListenerDescription ... var1);

        public Builder listenerDescriptions(Consumer<ListenerDescription.Builder> ... var1);

        public Builder policies(Policies var1);

        default public Builder policies(Consumer<Policies.Builder> policies) {
            return this.policies((Policies)((Policies.Builder)Policies.builder().applyMutation(policies)).build());
        }

        public Builder backendServerDescriptions(Collection<BackendServerDescription> var1);

        public Builder backendServerDescriptions(BackendServerDescription ... var1);

        public Builder backendServerDescriptions(Consumer<BackendServerDescription.Builder> ... var1);

        public Builder availabilityZones(Collection<String> var1);

        public Builder availabilityZones(String ... var1);

        public Builder subnets(Collection<String> var1);

        public Builder subnets(String ... var1);

        public Builder vpcId(String var1);

        public Builder instances(Collection<Instance> var1);

        public Builder instances(Instance ... var1);

        public Builder instances(Consumer<Instance.Builder> ... var1);

        public Builder healthCheck(HealthCheck var1);

        default public Builder healthCheck(Consumer<HealthCheck.Builder> healthCheck) {
            return this.healthCheck((HealthCheck)((HealthCheck.Builder)HealthCheck.builder().applyMutation(healthCheck)).build());
        }

        public Builder sourceSecurityGroup(SourceSecurityGroup var1);

        default public Builder sourceSecurityGroup(Consumer<SourceSecurityGroup.Builder> sourceSecurityGroup) {
            return this.sourceSecurityGroup((SourceSecurityGroup)((SourceSecurityGroup.Builder)SourceSecurityGroup.builder().applyMutation(sourceSecurityGroup)).build());
        }

        public Builder securityGroups(Collection<String> var1);

        public Builder securityGroups(String ... var1);

        public Builder createdTime(Instant var1);

        public Builder scheme(String var1);
    }
}

