/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.elasticloadbalancing.ElasticLoadBalancingAsyncClient;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancersRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancersResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.LoadBalancerDescription;

public class DescribeLoadBalancersPublisher
implements SdkPublisher<DescribeLoadBalancersResponse> {
    private final ElasticLoadBalancingAsyncClient client;
    private final DescribeLoadBalancersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeLoadBalancersPublisher(ElasticLoadBalancingAsyncClient client, DescribeLoadBalancersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeLoadBalancersPublisher(ElasticLoadBalancingAsyncClient client, DescribeLoadBalancersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeLoadBalancersResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeLoadBalancersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<LoadBalancerDescription> loadBalancerDescriptions() {
        Function<DescribeLoadBalancersResponse, Iterator> getIterator = response -> {
            if (response != null && response.loadBalancerDescriptions() != null) {
                return response.loadBalancerDescriptions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeLoadBalancersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private final DescribeLoadBalancersPublisher resume(DescribeLoadBalancersResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeLoadBalancersPublisher(this.client, (DescribeLoadBalancersRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.nextMarker()).build()));
        }
        return new DescribeLoadBalancersPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeLoadBalancersResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeLoadBalancersResponseFetcher
    implements AsyncPageFetcher<DescribeLoadBalancersResponse> {
        private DescribeLoadBalancersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeLoadBalancersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextMarker());
        }

        public CompletableFuture<DescribeLoadBalancersResponse> nextPage(DescribeLoadBalancersResponse previousPage) {
            if (previousPage == null) {
                return DescribeLoadBalancersPublisher.this.client.describeLoadBalancers(DescribeLoadBalancersPublisher.this.firstRequest);
            }
            return DescribeLoadBalancersPublisher.this.client.describeLoadBalancers((DescribeLoadBalancersRequest)((Object)DescribeLoadBalancersPublisher.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

