/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticloadbalancing.model.PolicyAttributeDescription;
import software.amazon.awssdk.services.elasticloadbalancing.model.PolicyAttributeDescriptionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PolicyDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PolicyDescription> {
    private static final SdkField<String> POLICY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyName").getter(PolicyDescription.getter(PolicyDescription::policyName)).setter(PolicyDescription.setter(Builder::policyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyName").build()}).build();
    private static final SdkField<String> POLICY_TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyTypeName").getter(PolicyDescription.getter(PolicyDescription::policyTypeName)).setter(PolicyDescription.setter(Builder::policyTypeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyTypeName").build()}).build();
    private static final SdkField<List<PolicyAttributeDescription>> POLICY_ATTRIBUTE_DESCRIPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PolicyAttributeDescriptions").getter(PolicyDescription.getter(PolicyDescription::policyAttributeDescriptions)).setter(PolicyDescription.setter(Builder::policyAttributeDescriptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyAttributeDescriptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PolicyAttributeDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_NAME_FIELD, POLICY_TYPE_NAME_FIELD, POLICY_ATTRIBUTE_DESCRIPTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("PolicyName", POLICY_NAME_FIELD);
            this.put("PolicyTypeName", POLICY_TYPE_NAME_FIELD);
            this.put("PolicyAttributeDescriptions", POLICY_ATTRIBUTE_DESCRIPTIONS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String policyName;
    private final String policyTypeName;
    private final List<PolicyAttributeDescription> policyAttributeDescriptions;

    private PolicyDescription(BuilderImpl builder) {
        this.policyName = builder.policyName;
        this.policyTypeName = builder.policyTypeName;
        this.policyAttributeDescriptions = builder.policyAttributeDescriptions;
    }

    public final String policyName() {
        return this.policyName;
    }

    public final String policyTypeName() {
        return this.policyTypeName;
    }

    public final boolean hasPolicyAttributeDescriptions() {
        return this.policyAttributeDescriptions != null && !(this.policyAttributeDescriptions instanceof SdkAutoConstructList);
    }

    public final List<PolicyAttributeDescription> policyAttributeDescriptions() {
        return this.policyAttributeDescriptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.policyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPolicyAttributeDescriptions() ? this.policyAttributeDescriptions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PolicyDescription)) {
            return false;
        }
        PolicyDescription other = (PolicyDescription)obj;
        return Objects.equals(this.policyName(), other.policyName()) && Objects.equals(this.policyTypeName(), other.policyTypeName()) && this.hasPolicyAttributeDescriptions() == other.hasPolicyAttributeDescriptions() && Objects.equals(this.policyAttributeDescriptions(), other.policyAttributeDescriptions());
    }

    public final String toString() {
        return ToString.builder((String)"PolicyDescription").add("PolicyName", (Object)this.policyName()).add("PolicyTypeName", (Object)this.policyTypeName()).add("PolicyAttributeDescriptions", this.hasPolicyAttributeDescriptions() ? this.policyAttributeDescriptions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PolicyName": {
                return Optional.ofNullable(clazz.cast(this.policyName()));
            }
            case "PolicyTypeName": {
                return Optional.ofNullable(clazz.cast(this.policyTypeName()));
            }
            case "PolicyAttributeDescriptions": {
                return Optional.ofNullable(clazz.cast(this.policyAttributeDescriptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PolicyDescription, T> g) {
        return obj -> g.apply((PolicyDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String policyName;
        private String policyTypeName;
        private List<PolicyAttributeDescription> policyAttributeDescriptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PolicyDescription model) {
            this.policyName(model.policyName);
            this.policyTypeName(model.policyTypeName);
            this.policyAttributeDescriptions(model.policyAttributeDescriptions);
        }

        public final String getPolicyName() {
            return this.policyName;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final String getPolicyTypeName() {
            return this.policyTypeName;
        }

        public final void setPolicyTypeName(String policyTypeName) {
            this.policyTypeName = policyTypeName;
        }

        @Override
        public final Builder policyTypeName(String policyTypeName) {
            this.policyTypeName = policyTypeName;
            return this;
        }

        public final List<PolicyAttributeDescription.Builder> getPolicyAttributeDescriptions() {
            List<PolicyAttributeDescription.Builder> result = PolicyAttributeDescriptionsCopier.copyToBuilder(this.policyAttributeDescriptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPolicyAttributeDescriptions(Collection<PolicyAttributeDescription.BuilderImpl> policyAttributeDescriptions) {
            this.policyAttributeDescriptions = PolicyAttributeDescriptionsCopier.copyFromBuilder(policyAttributeDescriptions);
        }

        @Override
        public final Builder policyAttributeDescriptions(Collection<PolicyAttributeDescription> policyAttributeDescriptions) {
            this.policyAttributeDescriptions = PolicyAttributeDescriptionsCopier.copy(policyAttributeDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyAttributeDescriptions(PolicyAttributeDescription ... policyAttributeDescriptions) {
            this.policyAttributeDescriptions(Arrays.asList(policyAttributeDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyAttributeDescriptions(Consumer<PolicyAttributeDescription.Builder> ... policyAttributeDescriptions) {
            this.policyAttributeDescriptions(Stream.of(policyAttributeDescriptions).map(c -> (PolicyAttributeDescription)((PolicyAttributeDescription.Builder)PolicyAttributeDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public PolicyDescription build() {
            return new PolicyDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PolicyDescription> {
        public Builder policyName(String var1);

        public Builder policyTypeName(String var1);

        public Builder policyAttributeDescriptions(Collection<PolicyAttributeDescription> var1);

        public Builder policyAttributeDescriptions(PolicyAttributeDescription ... var1);

        public Builder policyAttributeDescriptions(Consumer<PolicyAttributeDescription.Builder> ... var1);
    }
}

