/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.elasticloadbalancing.DefaultElasticLoadBalancingAsyncClient;
import software.amazon.awssdk.services.elasticloadbalancing.DefaultElasticLoadBalancingBaseClientBuilder;
import software.amazon.awssdk.services.elasticloadbalancing.ElasticLoadBalancingAsyncClient;
import software.amazon.awssdk.services.elasticloadbalancing.ElasticLoadBalancingAsyncClientBuilder;
import software.amazon.awssdk.services.elasticloadbalancing.ElasticLoadBalancingServiceClientConfiguration;
import software.amazon.awssdk.services.elasticloadbalancing.endpoints.ElasticLoadBalancingEndpointProvider;

@SdkInternalApi
final class DefaultElasticLoadBalancingAsyncClientBuilder
extends DefaultElasticLoadBalancingBaseClientBuilder<ElasticLoadBalancingAsyncClientBuilder, ElasticLoadBalancingAsyncClient>
implements ElasticLoadBalancingAsyncClientBuilder {
    DefaultElasticLoadBalancingAsyncClientBuilder() {
    }

    @Override
    public DefaultElasticLoadBalancingAsyncClientBuilder endpointProvider(ElasticLoadBalancingEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final ElasticLoadBalancingAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultElasticLoadBalancingAsyncClientBuilder.validateClientOptions(clientConfiguration);
        ElasticLoadBalancingServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultElasticLoadBalancingAsyncClient client = new DefaultElasticLoadBalancingAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private ElasticLoadBalancingServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return ElasticLoadBalancingServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

