/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.query.AwsQueryProtocolFactory;
import software.amazon.awssdk.services.elasticloadbalancing.ElasticLoadBalancingClient;
import software.amazon.awssdk.services.elasticloadbalancing.model.AddTagsRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.AddTagsResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.ApplySecurityGroupsToLoadBalancerRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.ApplySecurityGroupsToLoadBalancerResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.AttachLoadBalancerToSubnetsRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.AttachLoadBalancerToSubnetsResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.CertificateNotFoundException;
import software.amazon.awssdk.services.elasticloadbalancing.model.ConfigureHealthCheckRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.ConfigureHealthCheckResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.CreateAppCookieStickinessPolicyRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.CreateAppCookieStickinessPolicyResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.CreateLbCookieStickinessPolicyRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.CreateLbCookieStickinessPolicyResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.CreateLoadBalancerListenersRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.CreateLoadBalancerListenersResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.CreateLoadBalancerPolicyRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.CreateLoadBalancerPolicyResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.CreateLoadBalancerRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.CreateLoadBalancerResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.DeleteLoadBalancerListenersRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.DeleteLoadBalancerListenersResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.DeleteLoadBalancerPolicyRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.DeleteLoadBalancerPolicyResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.DeleteLoadBalancerRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.DeleteLoadBalancerResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.DependencyThrottleException;
import software.amazon.awssdk.services.elasticloadbalancing.model.DeregisterInstancesFromLoadBalancerRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.DeregisterInstancesFromLoadBalancerResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeAccountLimitsRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeAccountLimitsResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeInstanceHealthRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeInstanceHealthResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancerAttributesRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancerAttributesResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancerPoliciesRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancerPoliciesResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancerPolicyTypesRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancerPolicyTypesResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancersRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancersResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeTagsRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeTagsResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.DetachLoadBalancerFromSubnetsRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.DetachLoadBalancerFromSubnetsResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.DisableAvailabilityZonesForLoadBalancerRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.DisableAvailabilityZonesForLoadBalancerResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.DuplicateListenerException;
import software.amazon.awssdk.services.elasticloadbalancing.model.DuplicateLoadBalancerNameException;
import software.amazon.awssdk.services.elasticloadbalancing.model.DuplicatePolicyNameException;
import software.amazon.awssdk.services.elasticloadbalancing.model.DuplicateTagKeysException;
import software.amazon.awssdk.services.elasticloadbalancing.model.ElasticLoadBalancingException;
import software.amazon.awssdk.services.elasticloadbalancing.model.ElasticLoadBalancingRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.EnableAvailabilityZonesForLoadBalancerRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.EnableAvailabilityZonesForLoadBalancerResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.InvalidConfigurationRequestException;
import software.amazon.awssdk.services.elasticloadbalancing.model.InvalidInstanceException;
import software.amazon.awssdk.services.elasticloadbalancing.model.InvalidSchemeException;
import software.amazon.awssdk.services.elasticloadbalancing.model.InvalidSecurityGroupException;
import software.amazon.awssdk.services.elasticloadbalancing.model.InvalidSubnetException;
import software.amazon.awssdk.services.elasticloadbalancing.model.ListenerNotFoundException;
import software.amazon.awssdk.services.elasticloadbalancing.model.LoadBalancerAttributeNotFoundException;
import software.amazon.awssdk.services.elasticloadbalancing.model.LoadBalancerNotFoundException;
import software.amazon.awssdk.services.elasticloadbalancing.model.ModifyLoadBalancerAttributesRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.ModifyLoadBalancerAttributesResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.OperationNotPermittedException;
import software.amazon.awssdk.services.elasticloadbalancing.model.PolicyNotFoundException;
import software.amazon.awssdk.services.elasticloadbalancing.model.PolicyTypeNotFoundException;
import software.amazon.awssdk.services.elasticloadbalancing.model.RegisterInstancesWithLoadBalancerRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.RegisterInstancesWithLoadBalancerResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.RemoveTagsRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.RemoveTagsResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.SetLoadBalancerListenerSslCertificateRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.SetLoadBalancerListenerSslCertificateResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.SetLoadBalancerPoliciesForBackendServerRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.SetLoadBalancerPoliciesForBackendServerResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.SetLoadBalancerPoliciesOfListenerRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.SetLoadBalancerPoliciesOfListenerResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.SubnetNotFoundException;
import software.amazon.awssdk.services.elasticloadbalancing.model.TooManyLoadBalancersException;
import software.amazon.awssdk.services.elasticloadbalancing.model.TooManyPoliciesException;
import software.amazon.awssdk.services.elasticloadbalancing.model.TooManyTagsException;
import software.amazon.awssdk.services.elasticloadbalancing.model.UnsupportedProtocolException;
import software.amazon.awssdk.services.elasticloadbalancing.paginators.DescribeLoadBalancersIterable;
import software.amazon.awssdk.services.elasticloadbalancing.transform.AddTagsRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.ApplySecurityGroupsToLoadBalancerRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.AttachLoadBalancerToSubnetsRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.ConfigureHealthCheckRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.CreateAppCookieStickinessPolicyRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.CreateLbCookieStickinessPolicyRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.CreateLoadBalancerListenersRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.CreateLoadBalancerPolicyRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.CreateLoadBalancerRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.DeleteLoadBalancerListenersRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.DeleteLoadBalancerPolicyRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.DeleteLoadBalancerRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.DeregisterInstancesFromLoadBalancerRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.DescribeAccountLimitsRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.DescribeInstanceHealthRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.DescribeLoadBalancerAttributesRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.DescribeLoadBalancerPoliciesRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.DescribeLoadBalancerPolicyTypesRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.DescribeLoadBalancersRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.DescribeTagsRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.DetachLoadBalancerFromSubnetsRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.DisableAvailabilityZonesForLoadBalancerRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.EnableAvailabilityZonesForLoadBalancerRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.ModifyLoadBalancerAttributesRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.RegisterInstancesWithLoadBalancerRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.RemoveTagsRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.SetLoadBalancerListenerSslCertificateRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.SetLoadBalancerPoliciesForBackendServerRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.SetLoadBalancerPoliciesOfListenerRequestMarshaller;

@SdkInternalApi
final class DefaultElasticLoadBalancingClient
implements ElasticLoadBalancingClient {
    private final SyncClientHandler clientHandler;
    private final AwsQueryProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultElasticLoadBalancingClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init();
    }

    public final String serviceName() {
        return "elasticloadbalancing";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddTagsResponse addTags(AddTagsRequest addTagsRequest) throws LoadBalancerNotFoundException, TooManyTagsException, DuplicateTagKeysException, AwsServiceException, SdkClientException, ElasticLoadBalancingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(AddTagsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AddTags");
            AddTagsResponse addTagsResponse = (AddTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddTags").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)addTagsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new AddTagsRequestMarshaller(this.protocolFactory)));
            return addTagsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingClient.resolveMetricPublishers(this.clientConfiguration, addTagsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApplySecurityGroupsToLoadBalancerResponse applySecurityGroupsToLoadBalancer(ApplySecurityGroupsToLoadBalancerRequest applySecurityGroupsToLoadBalancerRequest) throws LoadBalancerNotFoundException, InvalidConfigurationRequestException, InvalidSecurityGroupException, AwsServiceException, SdkClientException, ElasticLoadBalancingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ApplySecurityGroupsToLoadBalancerResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ApplySecurityGroupsToLoadBalancer");
            ApplySecurityGroupsToLoadBalancerResponse applySecurityGroupsToLoadBalancerResponse = (ApplySecurityGroupsToLoadBalancerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ApplySecurityGroupsToLoadBalancer").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)applySecurityGroupsToLoadBalancerRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ApplySecurityGroupsToLoadBalancerRequestMarshaller(this.protocolFactory)));
            return applySecurityGroupsToLoadBalancerResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingClient.resolveMetricPublishers(this.clientConfiguration, applySecurityGroupsToLoadBalancerRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AttachLoadBalancerToSubnetsResponse attachLoadBalancerToSubnets(AttachLoadBalancerToSubnetsRequest attachLoadBalancerToSubnetsRequest) throws LoadBalancerNotFoundException, InvalidConfigurationRequestException, SubnetNotFoundException, InvalidSubnetException, AwsServiceException, SdkClientException, ElasticLoadBalancingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(AttachLoadBalancerToSubnetsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AttachLoadBalancerToSubnets");
            AttachLoadBalancerToSubnetsResponse attachLoadBalancerToSubnetsResponse = (AttachLoadBalancerToSubnetsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AttachLoadBalancerToSubnets").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)attachLoadBalancerToSubnetsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new AttachLoadBalancerToSubnetsRequestMarshaller(this.protocolFactory)));
            return attachLoadBalancerToSubnetsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingClient.resolveMetricPublishers(this.clientConfiguration, attachLoadBalancerToSubnetsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfigureHealthCheckResponse configureHealthCheck(ConfigureHealthCheckRequest configureHealthCheckRequest) throws LoadBalancerNotFoundException, AwsServiceException, SdkClientException, ElasticLoadBalancingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ConfigureHealthCheckResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ConfigureHealthCheck");
            ConfigureHealthCheckResponse configureHealthCheckResponse = (ConfigureHealthCheckResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ConfigureHealthCheck").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)configureHealthCheckRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ConfigureHealthCheckRequestMarshaller(this.protocolFactory)));
            return configureHealthCheckResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingClient.resolveMetricPublishers(this.clientConfiguration, configureHealthCheckRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateAppCookieStickinessPolicyResponse createAppCookieStickinessPolicy(CreateAppCookieStickinessPolicyRequest createAppCookieStickinessPolicyRequest) throws LoadBalancerNotFoundException, DuplicatePolicyNameException, TooManyPoliciesException, InvalidConfigurationRequestException, AwsServiceException, SdkClientException, ElasticLoadBalancingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateAppCookieStickinessPolicyResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateAppCookieStickinessPolicy");
            CreateAppCookieStickinessPolicyResponse createAppCookieStickinessPolicyResponse = (CreateAppCookieStickinessPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateAppCookieStickinessPolicy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createAppCookieStickinessPolicyRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new CreateAppCookieStickinessPolicyRequestMarshaller(this.protocolFactory)));
            return createAppCookieStickinessPolicyResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingClient.resolveMetricPublishers(this.clientConfiguration, createAppCookieStickinessPolicyRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateLbCookieStickinessPolicyResponse createLBCookieStickinessPolicy(CreateLbCookieStickinessPolicyRequest createLbCookieStickinessPolicyRequest) throws LoadBalancerNotFoundException, DuplicatePolicyNameException, TooManyPoliciesException, InvalidConfigurationRequestException, AwsServiceException, SdkClientException, ElasticLoadBalancingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateLbCookieStickinessPolicyResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateLBCookieStickinessPolicy");
            CreateLbCookieStickinessPolicyResponse createLbCookieStickinessPolicyResponse = (CreateLbCookieStickinessPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateLBCookieStickinessPolicy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createLbCookieStickinessPolicyRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new CreateLbCookieStickinessPolicyRequestMarshaller(this.protocolFactory)));
            return createLbCookieStickinessPolicyResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingClient.resolveMetricPublishers(this.clientConfiguration, createLbCookieStickinessPolicyRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateLoadBalancerResponse createLoadBalancer(CreateLoadBalancerRequest createLoadBalancerRequest) throws DuplicateLoadBalancerNameException, TooManyLoadBalancersException, CertificateNotFoundException, InvalidConfigurationRequestException, SubnetNotFoundException, InvalidSubnetException, InvalidSecurityGroupException, InvalidSchemeException, TooManyTagsException, DuplicateTagKeysException, UnsupportedProtocolException, OperationNotPermittedException, AwsServiceException, SdkClientException, ElasticLoadBalancingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateLoadBalancerResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateLoadBalancer");
            CreateLoadBalancerResponse createLoadBalancerResponse = (CreateLoadBalancerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateLoadBalancer").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createLoadBalancerRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new CreateLoadBalancerRequestMarshaller(this.protocolFactory)));
            return createLoadBalancerResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingClient.resolveMetricPublishers(this.clientConfiguration, createLoadBalancerRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateLoadBalancerListenersResponse createLoadBalancerListeners(CreateLoadBalancerListenersRequest createLoadBalancerListenersRequest) throws LoadBalancerNotFoundException, DuplicateListenerException, CertificateNotFoundException, InvalidConfigurationRequestException, UnsupportedProtocolException, AwsServiceException, SdkClientException, ElasticLoadBalancingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateLoadBalancerListenersResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateLoadBalancerListeners");
            CreateLoadBalancerListenersResponse createLoadBalancerListenersResponse = (CreateLoadBalancerListenersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateLoadBalancerListeners").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createLoadBalancerListenersRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new CreateLoadBalancerListenersRequestMarshaller(this.protocolFactory)));
            return createLoadBalancerListenersResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingClient.resolveMetricPublishers(this.clientConfiguration, createLoadBalancerListenersRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateLoadBalancerPolicyResponse createLoadBalancerPolicy(CreateLoadBalancerPolicyRequest createLoadBalancerPolicyRequest) throws LoadBalancerNotFoundException, PolicyTypeNotFoundException, DuplicatePolicyNameException, TooManyPoliciesException, InvalidConfigurationRequestException, AwsServiceException, SdkClientException, ElasticLoadBalancingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateLoadBalancerPolicyResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateLoadBalancerPolicy");
            CreateLoadBalancerPolicyResponse createLoadBalancerPolicyResponse = (CreateLoadBalancerPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateLoadBalancerPolicy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createLoadBalancerPolicyRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new CreateLoadBalancerPolicyRequestMarshaller(this.protocolFactory)));
            return createLoadBalancerPolicyResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingClient.resolveMetricPublishers(this.clientConfiguration, createLoadBalancerPolicyRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteLoadBalancerResponse deleteLoadBalancer(DeleteLoadBalancerRequest deleteLoadBalancerRequest) throws AwsServiceException, SdkClientException, ElasticLoadBalancingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteLoadBalancerResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteLoadBalancer");
            DeleteLoadBalancerResponse deleteLoadBalancerResponse = (DeleteLoadBalancerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteLoadBalancer").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteLoadBalancerRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DeleteLoadBalancerRequestMarshaller(this.protocolFactory)));
            return deleteLoadBalancerResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingClient.resolveMetricPublishers(this.clientConfiguration, deleteLoadBalancerRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteLoadBalancerListenersResponse deleteLoadBalancerListeners(DeleteLoadBalancerListenersRequest deleteLoadBalancerListenersRequest) throws LoadBalancerNotFoundException, AwsServiceException, SdkClientException, ElasticLoadBalancingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteLoadBalancerListenersResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteLoadBalancerListeners");
            DeleteLoadBalancerListenersResponse deleteLoadBalancerListenersResponse = (DeleteLoadBalancerListenersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteLoadBalancerListeners").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteLoadBalancerListenersRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DeleteLoadBalancerListenersRequestMarshaller(this.protocolFactory)));
            return deleteLoadBalancerListenersResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingClient.resolveMetricPublishers(this.clientConfiguration, deleteLoadBalancerListenersRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteLoadBalancerPolicyResponse deleteLoadBalancerPolicy(DeleteLoadBalancerPolicyRequest deleteLoadBalancerPolicyRequest) throws LoadBalancerNotFoundException, InvalidConfigurationRequestException, AwsServiceException, SdkClientException, ElasticLoadBalancingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteLoadBalancerPolicyResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteLoadBalancerPolicy");
            DeleteLoadBalancerPolicyResponse deleteLoadBalancerPolicyResponse = (DeleteLoadBalancerPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteLoadBalancerPolicy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteLoadBalancerPolicyRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DeleteLoadBalancerPolicyRequestMarshaller(this.protocolFactory)));
            return deleteLoadBalancerPolicyResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingClient.resolveMetricPublishers(this.clientConfiguration, deleteLoadBalancerPolicyRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeregisterInstancesFromLoadBalancerResponse deregisterInstancesFromLoadBalancer(DeregisterInstancesFromLoadBalancerRequest deregisterInstancesFromLoadBalancerRequest) throws LoadBalancerNotFoundException, InvalidInstanceException, AwsServiceException, SdkClientException, ElasticLoadBalancingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeregisterInstancesFromLoadBalancerResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeregisterInstancesFromLoadBalancer");
            DeregisterInstancesFromLoadBalancerResponse deregisterInstancesFromLoadBalancerResponse = (DeregisterInstancesFromLoadBalancerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeregisterInstancesFromLoadBalancer").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deregisterInstancesFromLoadBalancerRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DeregisterInstancesFromLoadBalancerRequestMarshaller(this.protocolFactory)));
            return deregisterInstancesFromLoadBalancerResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingClient.resolveMetricPublishers(this.clientConfiguration, deregisterInstancesFromLoadBalancerRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAccountLimitsResponse describeAccountLimits(DescribeAccountLimitsRequest describeAccountLimitsRequest) throws AwsServiceException, SdkClientException, ElasticLoadBalancingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeAccountLimitsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeAccountLimits");
            DescribeAccountLimitsResponse describeAccountLimitsResponse = (DescribeAccountLimitsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAccountLimits").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeAccountLimitsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DescribeAccountLimitsRequestMarshaller(this.protocolFactory)));
            return describeAccountLimitsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingClient.resolveMetricPublishers(this.clientConfiguration, describeAccountLimitsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeInstanceHealthResponse describeInstanceHealth(DescribeInstanceHealthRequest describeInstanceHealthRequest) throws LoadBalancerNotFoundException, InvalidInstanceException, AwsServiceException, SdkClientException, ElasticLoadBalancingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeInstanceHealthResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeInstanceHealth");
            DescribeInstanceHealthResponse describeInstanceHealthResponse = (DescribeInstanceHealthResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeInstanceHealth").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeInstanceHealthRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DescribeInstanceHealthRequestMarshaller(this.protocolFactory)));
            return describeInstanceHealthResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingClient.resolveMetricPublishers(this.clientConfiguration, describeInstanceHealthRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeLoadBalancerAttributesResponse describeLoadBalancerAttributes(DescribeLoadBalancerAttributesRequest describeLoadBalancerAttributesRequest) throws LoadBalancerNotFoundException, LoadBalancerAttributeNotFoundException, AwsServiceException, SdkClientException, ElasticLoadBalancingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeLoadBalancerAttributesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeLoadBalancerAttributes");
            DescribeLoadBalancerAttributesResponse describeLoadBalancerAttributesResponse = (DescribeLoadBalancerAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeLoadBalancerAttributes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeLoadBalancerAttributesRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DescribeLoadBalancerAttributesRequestMarshaller(this.protocolFactory)));
            return describeLoadBalancerAttributesResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingClient.resolveMetricPublishers(this.clientConfiguration, describeLoadBalancerAttributesRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeLoadBalancerPoliciesResponse describeLoadBalancerPolicies(DescribeLoadBalancerPoliciesRequest describeLoadBalancerPoliciesRequest) throws LoadBalancerNotFoundException, PolicyNotFoundException, AwsServiceException, SdkClientException, ElasticLoadBalancingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeLoadBalancerPoliciesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeLoadBalancerPolicies");
            DescribeLoadBalancerPoliciesResponse describeLoadBalancerPoliciesResponse = (DescribeLoadBalancerPoliciesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeLoadBalancerPolicies").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeLoadBalancerPoliciesRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DescribeLoadBalancerPoliciesRequestMarshaller(this.protocolFactory)));
            return describeLoadBalancerPoliciesResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingClient.resolveMetricPublishers(this.clientConfiguration, describeLoadBalancerPoliciesRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeLoadBalancerPolicyTypesResponse describeLoadBalancerPolicyTypes(DescribeLoadBalancerPolicyTypesRequest describeLoadBalancerPolicyTypesRequest) throws PolicyTypeNotFoundException, AwsServiceException, SdkClientException, ElasticLoadBalancingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeLoadBalancerPolicyTypesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeLoadBalancerPolicyTypes");
            DescribeLoadBalancerPolicyTypesResponse describeLoadBalancerPolicyTypesResponse = (DescribeLoadBalancerPolicyTypesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeLoadBalancerPolicyTypes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeLoadBalancerPolicyTypesRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DescribeLoadBalancerPolicyTypesRequestMarshaller(this.protocolFactory)));
            return describeLoadBalancerPolicyTypesResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingClient.resolveMetricPublishers(this.clientConfiguration, describeLoadBalancerPolicyTypesRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeLoadBalancersResponse describeLoadBalancers(DescribeLoadBalancersRequest describeLoadBalancersRequest) throws LoadBalancerNotFoundException, DependencyThrottleException, AwsServiceException, SdkClientException, ElasticLoadBalancingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeLoadBalancersResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeLoadBalancers");
            DescribeLoadBalancersResponse describeLoadBalancersResponse = (DescribeLoadBalancersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeLoadBalancers").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeLoadBalancersRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DescribeLoadBalancersRequestMarshaller(this.protocolFactory)));
            return describeLoadBalancersResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingClient.resolveMetricPublishers(this.clientConfiguration, describeLoadBalancersRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public DescribeLoadBalancersIterable describeLoadBalancersPaginator(DescribeLoadBalancersRequest describeLoadBalancersRequest) throws LoadBalancerNotFoundException, DependencyThrottleException, AwsServiceException, SdkClientException, ElasticLoadBalancingException {
        return new DescribeLoadBalancersIterable(this, this.applyPaginatorUserAgent(describeLoadBalancersRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeTagsResponse describeTags(DescribeTagsRequest describeTagsRequest) throws LoadBalancerNotFoundException, AwsServiceException, SdkClientException, ElasticLoadBalancingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeTagsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeTags");
            DescribeTagsResponse describeTagsResponse = (DescribeTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTags").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeTagsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DescribeTagsRequestMarshaller(this.protocolFactory)));
            return describeTagsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingClient.resolveMetricPublishers(this.clientConfiguration, describeTagsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DetachLoadBalancerFromSubnetsResponse detachLoadBalancerFromSubnets(DetachLoadBalancerFromSubnetsRequest detachLoadBalancerFromSubnetsRequest) throws LoadBalancerNotFoundException, InvalidConfigurationRequestException, AwsServiceException, SdkClientException, ElasticLoadBalancingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DetachLoadBalancerFromSubnetsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DetachLoadBalancerFromSubnets");
            DetachLoadBalancerFromSubnetsResponse detachLoadBalancerFromSubnetsResponse = (DetachLoadBalancerFromSubnetsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetachLoadBalancerFromSubnets").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)detachLoadBalancerFromSubnetsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DetachLoadBalancerFromSubnetsRequestMarshaller(this.protocolFactory)));
            return detachLoadBalancerFromSubnetsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingClient.resolveMetricPublishers(this.clientConfiguration, detachLoadBalancerFromSubnetsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisableAvailabilityZonesForLoadBalancerResponse disableAvailabilityZonesForLoadBalancer(DisableAvailabilityZonesForLoadBalancerRequest disableAvailabilityZonesForLoadBalancerRequest) throws LoadBalancerNotFoundException, InvalidConfigurationRequestException, AwsServiceException, SdkClientException, ElasticLoadBalancingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DisableAvailabilityZonesForLoadBalancerResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisableAvailabilityZonesForLoadBalancer");
            DisableAvailabilityZonesForLoadBalancerResponse disableAvailabilityZonesForLoadBalancerResponse = (DisableAvailabilityZonesForLoadBalancerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisableAvailabilityZonesForLoadBalancer").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disableAvailabilityZonesForLoadBalancerRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DisableAvailabilityZonesForLoadBalancerRequestMarshaller(this.protocolFactory)));
            return disableAvailabilityZonesForLoadBalancerResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingClient.resolveMetricPublishers(this.clientConfiguration, disableAvailabilityZonesForLoadBalancerRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnableAvailabilityZonesForLoadBalancerResponse enableAvailabilityZonesForLoadBalancer(EnableAvailabilityZonesForLoadBalancerRequest enableAvailabilityZonesForLoadBalancerRequest) throws LoadBalancerNotFoundException, AwsServiceException, SdkClientException, ElasticLoadBalancingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(EnableAvailabilityZonesForLoadBalancerResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"EnableAvailabilityZonesForLoadBalancer");
            EnableAvailabilityZonesForLoadBalancerResponse enableAvailabilityZonesForLoadBalancerResponse = (EnableAvailabilityZonesForLoadBalancerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnableAvailabilityZonesForLoadBalancer").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)enableAvailabilityZonesForLoadBalancerRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new EnableAvailabilityZonesForLoadBalancerRequestMarshaller(this.protocolFactory)));
            return enableAvailabilityZonesForLoadBalancerResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingClient.resolveMetricPublishers(this.clientConfiguration, enableAvailabilityZonesForLoadBalancerRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModifyLoadBalancerAttributesResponse modifyLoadBalancerAttributes(ModifyLoadBalancerAttributesRequest modifyLoadBalancerAttributesRequest) throws LoadBalancerNotFoundException, LoadBalancerAttributeNotFoundException, InvalidConfigurationRequestException, AwsServiceException, SdkClientException, ElasticLoadBalancingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyLoadBalancerAttributesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifyLoadBalancerAttributes");
            ModifyLoadBalancerAttributesResponse modifyLoadBalancerAttributesResponse = (ModifyLoadBalancerAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyLoadBalancerAttributes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifyLoadBalancerAttributesRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ModifyLoadBalancerAttributesRequestMarshaller(this.protocolFactory)));
            return modifyLoadBalancerAttributesResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingClient.resolveMetricPublishers(this.clientConfiguration, modifyLoadBalancerAttributesRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RegisterInstancesWithLoadBalancerResponse registerInstancesWithLoadBalancer(RegisterInstancesWithLoadBalancerRequest registerInstancesWithLoadBalancerRequest) throws LoadBalancerNotFoundException, InvalidInstanceException, AwsServiceException, SdkClientException, ElasticLoadBalancingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(RegisterInstancesWithLoadBalancerResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RegisterInstancesWithLoadBalancer");
            RegisterInstancesWithLoadBalancerResponse registerInstancesWithLoadBalancerResponse = (RegisterInstancesWithLoadBalancerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RegisterInstancesWithLoadBalancer").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)registerInstancesWithLoadBalancerRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new RegisterInstancesWithLoadBalancerRequestMarshaller(this.protocolFactory)));
            return registerInstancesWithLoadBalancerResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingClient.resolveMetricPublishers(this.clientConfiguration, registerInstancesWithLoadBalancerRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoveTagsResponse removeTags(RemoveTagsRequest removeTagsRequest) throws LoadBalancerNotFoundException, AwsServiceException, SdkClientException, ElasticLoadBalancingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(RemoveTagsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RemoveTags");
            RemoveTagsResponse removeTagsResponse = (RemoveTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemoveTags").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)removeTagsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new RemoveTagsRequestMarshaller(this.protocolFactory)));
            return removeTagsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingClient.resolveMetricPublishers(this.clientConfiguration, removeTagsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SetLoadBalancerListenerSslCertificateResponse setLoadBalancerListenerSSLCertificate(SetLoadBalancerListenerSslCertificateRequest setLoadBalancerListenerSslCertificateRequest) throws CertificateNotFoundException, LoadBalancerNotFoundException, ListenerNotFoundException, InvalidConfigurationRequestException, UnsupportedProtocolException, AwsServiceException, SdkClientException, ElasticLoadBalancingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(SetLoadBalancerListenerSslCertificateResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SetLoadBalancerListenerSSLCertificate");
            SetLoadBalancerListenerSslCertificateResponse setLoadBalancerListenerSslCertificateResponse = (SetLoadBalancerListenerSslCertificateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetLoadBalancerListenerSSLCertificate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)setLoadBalancerListenerSslCertificateRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new SetLoadBalancerListenerSslCertificateRequestMarshaller(this.protocolFactory)));
            return setLoadBalancerListenerSslCertificateResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingClient.resolveMetricPublishers(this.clientConfiguration, setLoadBalancerListenerSslCertificateRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SetLoadBalancerPoliciesForBackendServerResponse setLoadBalancerPoliciesForBackendServer(SetLoadBalancerPoliciesForBackendServerRequest setLoadBalancerPoliciesForBackendServerRequest) throws LoadBalancerNotFoundException, PolicyNotFoundException, InvalidConfigurationRequestException, AwsServiceException, SdkClientException, ElasticLoadBalancingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(SetLoadBalancerPoliciesForBackendServerResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SetLoadBalancerPoliciesForBackendServer");
            SetLoadBalancerPoliciesForBackendServerResponse setLoadBalancerPoliciesForBackendServerResponse = (SetLoadBalancerPoliciesForBackendServerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetLoadBalancerPoliciesForBackendServer").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)setLoadBalancerPoliciesForBackendServerRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new SetLoadBalancerPoliciesForBackendServerRequestMarshaller(this.protocolFactory)));
            return setLoadBalancerPoliciesForBackendServerResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingClient.resolveMetricPublishers(this.clientConfiguration, setLoadBalancerPoliciesForBackendServerRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SetLoadBalancerPoliciesOfListenerResponse setLoadBalancerPoliciesOfListener(SetLoadBalancerPoliciesOfListenerRequest setLoadBalancerPoliciesOfListenerRequest) throws LoadBalancerNotFoundException, PolicyNotFoundException, ListenerNotFoundException, InvalidConfigurationRequestException, AwsServiceException, SdkClientException, ElasticLoadBalancingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(SetLoadBalancerPoliciesOfListenerResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SetLoadBalancerPoliciesOfListener");
            SetLoadBalancerPoliciesOfListenerResponse setLoadBalancerPoliciesOfListenerResponse = (SetLoadBalancerPoliciesOfListenerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetLoadBalancerPoliciesOfListener").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)setLoadBalancerPoliciesOfListenerRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new SetLoadBalancerPoliciesOfListenerRequestMarshaller(this.protocolFactory)));
            return setLoadBalancerPoliciesOfListenerResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingClient.resolveMetricPublishers(this.clientConfiguration, setLoadBalancerPoliciesOfListenerRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private AwsQueryProtocolFactory init() {
        return AwsQueryProtocolFactory.builder().registerModeledException(ExceptionMetadata.builder().errorCode("UnsupportedProtocol").exceptionBuilderSupplier(UnsupportedProtocolException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LoadBalancerAttributeNotFound").exceptionBuilderSupplier(LoadBalancerAttributeNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LoadBalancerNotFound").exceptionBuilderSupplier(LoadBalancerNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyLoadBalancers").exceptionBuilderSupplier(TooManyLoadBalancersException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidConfigurationRequest").exceptionBuilderSupplier(InvalidConfigurationRequestException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidSecurityGroup").exceptionBuilderSupplier(InvalidSecurityGroupException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DuplicateLoadBalancerName").exceptionBuilderSupplier(DuplicateLoadBalancerNameException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DependencyThrottle").exceptionBuilderSupplier(DependencyThrottleException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("OperationNotPermitted").exceptionBuilderSupplier(OperationNotPermittedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PolicyNotFound").exceptionBuilderSupplier(PolicyNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CertificateNotFound").exceptionBuilderSupplier(CertificateNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DuplicateTagKeys").exceptionBuilderSupplier(DuplicateTagKeysException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyTags").exceptionBuilderSupplier(TooManyTagsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ListenerNotFound").exceptionBuilderSupplier(ListenerNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyPolicies").exceptionBuilderSupplier(TooManyPoliciesException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DuplicatePolicyName").exceptionBuilderSupplier(DuplicatePolicyNameException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SubnetNotFound").exceptionBuilderSupplier(SubnetNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DuplicateListener").exceptionBuilderSupplier(DuplicateListenerException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidScheme").exceptionBuilderSupplier(InvalidSchemeException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PolicyTypeNotFound").exceptionBuilderSupplier(PolicyTypeNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidSubnet").exceptionBuilderSupplier(InvalidSubnetException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidInstance").exceptionBuilderSupplier(InvalidInstanceException::builder).httpStatusCode(Integer.valueOf(400)).build()).clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(ElasticLoadBalancingException::builder).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends ElasticLoadBalancingRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.13.62").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((ElasticLoadBalancingRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }
}

