/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for CreateAppCookieStickinessPolicy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAppCookieStickinessPolicyRequest extends ElasticLoadBalancingRequest implements
        ToCopyableBuilder<CreateAppCookieStickinessPolicyRequest.Builder, CreateAppCookieStickinessPolicyRequest> {
    private static final SdkField<String> LOAD_BALANCER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateAppCookieStickinessPolicyRequest::loadBalancerName)).setter(setter(Builder::loadBalancerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerName").build()).build();

    private static final SdkField<String> POLICY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateAppCookieStickinessPolicyRequest::policyName)).setter(setter(Builder::policyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyName").build()).build();

    private static final SdkField<String> COOKIE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateAppCookieStickinessPolicyRequest::cookieName)).setter(setter(Builder::cookieName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CookieName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOAD_BALANCER_NAME_FIELD,
            POLICY_NAME_FIELD, COOKIE_NAME_FIELD));

    private final String loadBalancerName;

    private final String policyName;

    private final String cookieName;

    private CreateAppCookieStickinessPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.loadBalancerName = builder.loadBalancerName;
        this.policyName = builder.policyName;
        this.cookieName = builder.cookieName;
    }

    /**
     * <p>
     * The name of the load balancer.
     * </p>
     * 
     * @return The name of the load balancer.
     */
    public String loadBalancerName() {
        return loadBalancerName;
    }

    /**
     * <p>
     * The name of the policy being created. Policy names must consist of alphanumeric characters and dashes (-). This
     * name must be unique within the set of policies for this load balancer.
     * </p>
     * 
     * @return The name of the policy being created. Policy names must consist of alphanumeric characters and dashes
     *         (-). This name must be unique within the set of policies for this load balancer.
     */
    public String policyName() {
        return policyName;
    }

    /**
     * <p>
     * The name of the application cookie used for stickiness.
     * </p>
     * 
     * @return The name of the application cookie used for stickiness.
     */
    public String cookieName() {
        return cookieName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(loadBalancerName());
        hashCode = 31 * hashCode + Objects.hashCode(policyName());
        hashCode = 31 * hashCode + Objects.hashCode(cookieName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAppCookieStickinessPolicyRequest)) {
            return false;
        }
        CreateAppCookieStickinessPolicyRequest other = (CreateAppCookieStickinessPolicyRequest) obj;
        return Objects.equals(loadBalancerName(), other.loadBalancerName()) && Objects.equals(policyName(), other.policyName())
                && Objects.equals(cookieName(), other.cookieName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateAppCookieStickinessPolicyRequest").add("LoadBalancerName", loadBalancerName())
                .add("PolicyName", policyName()).add("CookieName", cookieName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LoadBalancerName":
            return Optional.ofNullable(clazz.cast(loadBalancerName()));
        case "PolicyName":
            return Optional.ofNullable(clazz.cast(policyName()));
        case "CookieName":
            return Optional.ofNullable(clazz.cast(cookieName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAppCookieStickinessPolicyRequest, T> g) {
        return obj -> g.apply((CreateAppCookieStickinessPolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticLoadBalancingRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateAppCookieStickinessPolicyRequest> {
        /**
         * <p>
         * The name of the load balancer.
         * </p>
         * 
         * @param loadBalancerName
         *        The name of the load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerName(String loadBalancerName);

        /**
         * <p>
         * The name of the policy being created. Policy names must consist of alphanumeric characters and dashes (-).
         * This name must be unique within the set of policies for this load balancer.
         * </p>
         * 
         * @param policyName
         *        The name of the policy being created. Policy names must consist of alphanumeric characters and dashes
         *        (-). This name must be unique within the set of policies for this load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyName(String policyName);

        /**
         * <p>
         * The name of the application cookie used for stickiness.
         * </p>
         * 
         * @param cookieName
         *        The name of the application cookie used for stickiness.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cookieName(String cookieName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElasticLoadBalancingRequest.BuilderImpl implements Builder {
        private String loadBalancerName;

        private String policyName;

        private String cookieName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAppCookieStickinessPolicyRequest model) {
            super(model);
            loadBalancerName(model.loadBalancerName);
            policyName(model.policyName);
            cookieName(model.cookieName);
        }

        public final String getLoadBalancerName() {
            return loadBalancerName;
        }

        @Override
        public final Builder loadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
            return this;
        }

        public final void setLoadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
        }

        public final String getPolicyName() {
            return policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        public final String getCookieName() {
            return cookieName;
        }

        @Override
        public final Builder cookieName(String cookieName) {
            this.cookieName = cookieName;
            return this;
        }

        public final void setCookieName(String cookieName) {
            this.cookieName = cookieName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAppCookieStickinessPolicyRequest build() {
            return new CreateAppCookieStickinessPolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
