/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a source security group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SourceSecurityGroup implements SdkPojo, Serializable,
        ToCopyableBuilder<SourceSecurityGroup.Builder, SourceSecurityGroup> {
    private static final SdkField<String> OWNER_ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SourceSecurityGroup::ownerAlias)).setter(setter(Builder::ownerAlias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerAlias").build()).build();

    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SourceSecurityGroup::groupName)).setter(setter(Builder::groupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OWNER_ALIAS_FIELD,
            GROUP_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String ownerAlias;

    private final String groupName;

    private SourceSecurityGroup(BuilderImpl builder) {
        this.ownerAlias = builder.ownerAlias;
        this.groupName = builder.groupName;
    }

    /**
     * <p>
     * The owner of the security group.
     * </p>
     * 
     * @return The owner of the security group.
     */
    public String ownerAlias() {
        return ownerAlias;
    }

    /**
     * <p>
     * The name of the security group.
     * </p>
     * 
     * @return The name of the security group.
     */
    public String groupName() {
        return groupName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ownerAlias());
        hashCode = 31 * hashCode + Objects.hashCode(groupName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceSecurityGroup)) {
            return false;
        }
        SourceSecurityGroup other = (SourceSecurityGroup) obj;
        return Objects.equals(ownerAlias(), other.ownerAlias()) && Objects.equals(groupName(), other.groupName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SourceSecurityGroup").add("OwnerAlias", ownerAlias()).add("GroupName", groupName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OwnerAlias":
            return Optional.ofNullable(clazz.cast(ownerAlias()));
        case "GroupName":
            return Optional.ofNullable(clazz.cast(groupName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SourceSecurityGroup, T> g) {
        return obj -> g.apply((SourceSecurityGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SourceSecurityGroup> {
        /**
         * <p>
         * The owner of the security group.
         * </p>
         * 
         * @param ownerAlias
         *        The owner of the security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerAlias(String ownerAlias);

        /**
         * <p>
         * The name of the security group.
         * </p>
         * 
         * @param groupName
         *        The name of the security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupName(String groupName);
    }

    static final class BuilderImpl implements Builder {
        private String ownerAlias;

        private String groupName;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceSecurityGroup model) {
            ownerAlias(model.ownerAlias);
            groupName(model.groupName);
        }

        public final String getOwnerAlias() {
            return ownerAlias;
        }

        @Override
        public final Builder ownerAlias(String ownerAlias) {
            this.ownerAlias = ownerAlias;
            return this;
        }

        public final void setOwnerAlias(String ownerAlias) {
            this.ownerAlias = ownerAlias;
        }

        public final String getGroupName() {
            return groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        @Override
        public SourceSecurityGroup build() {
            return new SourceSecurityGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
