/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a policy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PolicyDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<PolicyDescription.Builder, PolicyDescription> {
    private static final SdkField<String> POLICY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PolicyDescription::policyName)).setter(setter(Builder::policyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyName").build()).build();

    private static final SdkField<String> POLICY_TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PolicyDescription::policyTypeName)).setter(setter(Builder::policyTypeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyTypeName").build()).build();

    private static final SdkField<List<PolicyAttributeDescription>> POLICY_ATTRIBUTE_DESCRIPTIONS_FIELD = SdkField
            .<List<PolicyAttributeDescription>> builder(MarshallingType.LIST)
            .getter(getter(PolicyDescription::policyAttributeDescriptions))
            .setter(setter(Builder::policyAttributeDescriptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyAttributeDescriptions")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PolicyAttributeDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(PolicyAttributeDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_NAME_FIELD,
            POLICY_TYPE_NAME_FIELD, POLICY_ATTRIBUTE_DESCRIPTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String policyName;

    private final String policyTypeName;

    private final List<PolicyAttributeDescription> policyAttributeDescriptions;

    private PolicyDescription(BuilderImpl builder) {
        this.policyName = builder.policyName;
        this.policyTypeName = builder.policyTypeName;
        this.policyAttributeDescriptions = builder.policyAttributeDescriptions;
    }

    /**
     * <p>
     * The name of the policy.
     * </p>
     * 
     * @return The name of the policy.
     */
    public String policyName() {
        return policyName;
    }

    /**
     * <p>
     * The name of the policy type.
     * </p>
     * 
     * @return The name of the policy type.
     */
    public String policyTypeName() {
        return policyTypeName;
    }

    /**
     * Returns true if the PolicyAttributeDescriptions property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public boolean hasPolicyAttributeDescriptions() {
        return policyAttributeDescriptions != null && !(policyAttributeDescriptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The policy attributes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPolicyAttributeDescriptions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The policy attributes.
     */
    public List<PolicyAttributeDescription> policyAttributeDescriptions() {
        return policyAttributeDescriptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(policyName());
        hashCode = 31 * hashCode + Objects.hashCode(policyTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(policyAttributeDescriptions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PolicyDescription)) {
            return false;
        }
        PolicyDescription other = (PolicyDescription) obj;
        return Objects.equals(policyName(), other.policyName()) && Objects.equals(policyTypeName(), other.policyTypeName())
                && Objects.equals(policyAttributeDescriptions(), other.policyAttributeDescriptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PolicyDescription").add("PolicyName", policyName()).add("PolicyTypeName", policyTypeName())
                .add("PolicyAttributeDescriptions", policyAttributeDescriptions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PolicyName":
            return Optional.ofNullable(clazz.cast(policyName()));
        case "PolicyTypeName":
            return Optional.ofNullable(clazz.cast(policyTypeName()));
        case "PolicyAttributeDescriptions":
            return Optional.ofNullable(clazz.cast(policyAttributeDescriptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PolicyDescription, T> g) {
        return obj -> g.apply((PolicyDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PolicyDescription> {
        /**
         * <p>
         * The name of the policy.
         * </p>
         * 
         * @param policyName
         *        The name of the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyName(String policyName);

        /**
         * <p>
         * The name of the policy type.
         * </p>
         * 
         * @param policyTypeName
         *        The name of the policy type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyTypeName(String policyTypeName);

        /**
         * <p>
         * The policy attributes.
         * </p>
         * 
         * @param policyAttributeDescriptions
         *        The policy attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyAttributeDescriptions(Collection<PolicyAttributeDescription> policyAttributeDescriptions);

        /**
         * <p>
         * The policy attributes.
         * </p>
         * 
         * @param policyAttributeDescriptions
         *        The policy attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyAttributeDescriptions(PolicyAttributeDescription... policyAttributeDescriptions);

        /**
         * <p>
         * The policy attributes.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PolicyAttributeDescription>.Builder}
         * avoiding the need to create one manually via {@link List<PolicyAttributeDescription>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PolicyAttributeDescription>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #policyAttributeDescriptions(List<PolicyAttributeDescription>)}.
         * 
         * @param policyAttributeDescriptions
         *        a consumer that will call methods on {@link List<PolicyAttributeDescription>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #policyAttributeDescriptions(List<PolicyAttributeDescription>)
         */
        Builder policyAttributeDescriptions(Consumer<PolicyAttributeDescription.Builder>... policyAttributeDescriptions);
    }

    static final class BuilderImpl implements Builder {
        private String policyName;

        private String policyTypeName;

        private List<PolicyAttributeDescription> policyAttributeDescriptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PolicyDescription model) {
            policyName(model.policyName);
            policyTypeName(model.policyTypeName);
            policyAttributeDescriptions(model.policyAttributeDescriptions);
        }

        public final String getPolicyName() {
            return policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        public final String getPolicyTypeName() {
            return policyTypeName;
        }

        @Override
        public final Builder policyTypeName(String policyTypeName) {
            this.policyTypeName = policyTypeName;
            return this;
        }

        public final void setPolicyTypeName(String policyTypeName) {
            this.policyTypeName = policyTypeName;
        }

        public final Collection<PolicyAttributeDescription.Builder> getPolicyAttributeDescriptions() {
            return policyAttributeDescriptions != null ? policyAttributeDescriptions.stream()
                    .map(PolicyAttributeDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder policyAttributeDescriptions(Collection<PolicyAttributeDescription> policyAttributeDescriptions) {
            this.policyAttributeDescriptions = PolicyAttributeDescriptionsCopier.copy(policyAttributeDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyAttributeDescriptions(PolicyAttributeDescription... policyAttributeDescriptions) {
            policyAttributeDescriptions(Arrays.asList(policyAttributeDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyAttributeDescriptions(
                Consumer<PolicyAttributeDescription.Builder>... policyAttributeDescriptions) {
            policyAttributeDescriptions(Stream.of(policyAttributeDescriptions)
                    .map(c -> PolicyAttributeDescription.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPolicyAttributeDescriptions(
                Collection<PolicyAttributeDescription.BuilderImpl> policyAttributeDescriptions) {
            this.policyAttributeDescriptions = PolicyAttributeDescriptionsCopier.copyFromBuilder(policyAttributeDescriptions);
        }

        @Override
        public PolicyDescription build() {
            return new PolicyDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
