/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DescribeLoadBalancerPolicyTypes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeLoadBalancerPolicyTypesRequest extends ElasticLoadBalancingRequest implements
        ToCopyableBuilder<DescribeLoadBalancerPolicyTypesRequest.Builder, DescribeLoadBalancerPolicyTypesRequest> {
    private static final SdkField<List<String>> POLICY_TYPE_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DescribeLoadBalancerPolicyTypesRequest::policyTypeNames))
            .setter(setter(Builder::policyTypeNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyTypeNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_TYPE_NAMES_FIELD));

    private final List<String> policyTypeNames;

    private DescribeLoadBalancerPolicyTypesRequest(BuilderImpl builder) {
        super(builder);
        this.policyTypeNames = builder.policyTypeNames;
    }

    /**
     * Returns true if the PolicyTypeNames property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasPolicyTypeNames() {
        return policyTypeNames != null && !(policyTypeNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The names of the policy types. If no names are specified, describes all policy types defined by Elastic Load
     * Balancing.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPolicyTypeNames()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The names of the policy types. If no names are specified, describes all policy types defined by Elastic
     *         Load Balancing.
     */
    public List<String> policyTypeNames() {
        return policyTypeNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(policyTypeNames());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLoadBalancerPolicyTypesRequest)) {
            return false;
        }
        DescribeLoadBalancerPolicyTypesRequest other = (DescribeLoadBalancerPolicyTypesRequest) obj;
        return Objects.equals(policyTypeNames(), other.policyTypeNames());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeLoadBalancerPolicyTypesRequest").add("PolicyTypeNames", policyTypeNames()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PolicyTypeNames":
            return Optional.ofNullable(clazz.cast(policyTypeNames()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeLoadBalancerPolicyTypesRequest, T> g) {
        return obj -> g.apply((DescribeLoadBalancerPolicyTypesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticLoadBalancingRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeLoadBalancerPolicyTypesRequest> {
        /**
         * <p>
         * The names of the policy types. If no names are specified, describes all policy types defined by Elastic Load
         * Balancing.
         * </p>
         * 
         * @param policyTypeNames
         *        The names of the policy types. If no names are specified, describes all policy types defined by
         *        Elastic Load Balancing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyTypeNames(Collection<String> policyTypeNames);

        /**
         * <p>
         * The names of the policy types. If no names are specified, describes all policy types defined by Elastic Load
         * Balancing.
         * </p>
         * 
         * @param policyTypeNames
         *        The names of the policy types. If no names are specified, describes all policy types defined by
         *        Elastic Load Balancing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyTypeNames(String... policyTypeNames);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElasticLoadBalancingRequest.BuilderImpl implements Builder {
        private List<String> policyTypeNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLoadBalancerPolicyTypesRequest model) {
            super(model);
            policyTypeNames(model.policyTypeNames);
        }

        public final Collection<String> getPolicyTypeNames() {
            return policyTypeNames;
        }

        @Override
        public final Builder policyTypeNames(Collection<String> policyTypeNames) {
            this.policyTypeNames = PolicyTypeNamesCopier.copy(policyTypeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyTypeNames(String... policyTypeNames) {
            policyTypeNames(Arrays.asList(policyTypeNames));
            return this;
        }

        public final void setPolicyTypeNames(Collection<String> policyTypeNames) {
            this.policyTypeNames = PolicyTypeNamesCopier.copy(policyTypeNames);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeLoadBalancerPolicyTypesRequest build() {
            return new DescribeLoadBalancerPolicyTypesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
