/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class LBCookieStickinessPolicy
implements ToCopyableBuilder<Builder, LBCookieStickinessPolicy> {
    private final String policyName;
    private final Long cookieExpirationPeriod;

    private LBCookieStickinessPolicy(BuilderImpl builder) {
        this.policyName = builder.policyName;
        this.cookieExpirationPeriod = builder.cookieExpirationPeriod;
    }

    public String policyName() {
        return this.policyName;
    }

    public Long cookieExpirationPeriod() {
        return this.cookieExpirationPeriod;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.policyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.cookieExpirationPeriod());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LBCookieStickinessPolicy)) {
            return false;
        }
        LBCookieStickinessPolicy other = (LBCookieStickinessPolicy)obj;
        return Objects.equals(this.policyName(), other.policyName()) && Objects.equals(this.cookieExpirationPeriod(), other.cookieExpirationPeriod());
    }

    public String toString() {
        return ToString.builder((String)"LBCookieStickinessPolicy").add("PolicyName", (Object)this.policyName()).add("CookieExpirationPeriod", (Object)this.cookieExpirationPeriod()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PolicyName": {
                return Optional.of(clazz.cast(this.policyName()));
            }
            case "CookieExpirationPeriod": {
                return Optional.of(clazz.cast(this.cookieExpirationPeriod()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String policyName;
        private Long cookieExpirationPeriod;

        private BuilderImpl() {
        }

        private BuilderImpl(LBCookieStickinessPolicy model) {
            this.policyName(model.policyName);
            this.cookieExpirationPeriod(model.cookieExpirationPeriod);
        }

        public final String getPolicyName() {
            return this.policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        public final Long getCookieExpirationPeriod() {
            return this.cookieExpirationPeriod;
        }

        @Override
        public final Builder cookieExpirationPeriod(Long cookieExpirationPeriod) {
            this.cookieExpirationPeriod = cookieExpirationPeriod;
            return this;
        }

        public final void setCookieExpirationPeriod(Long cookieExpirationPeriod) {
            this.cookieExpirationPeriod = cookieExpirationPeriod;
        }

        public LBCookieStickinessPolicy build() {
            return new LBCookieStickinessPolicy(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, LBCookieStickinessPolicy> {
        public Builder policyName(String var1);

        public Builder cookieExpirationPeriod(Long var1);
    }
}

