/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.elasticloadbalancing.model.DisableAvailabilityZonesForLoadBalancerRequest;

public class DisableAvailabilityZonesForLoadBalancerRequestMarshaller
implements Marshaller<Request<DisableAvailabilityZonesForLoadBalancerRequest>, DisableAvailabilityZonesForLoadBalancerRequest> {
    public Request<DisableAvailabilityZonesForLoadBalancerRequest> marshall(DisableAvailabilityZonesForLoadBalancerRequest disableAvailabilityZonesForLoadBalancerRequest) {
        List<String> availabilityZonesList;
        if (disableAvailabilityZonesForLoadBalancerRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)disableAvailabilityZonesForLoadBalancerRequest, "ElasticLoadBalancingClient");
        request.addParameter("Action", "DisableAvailabilityZonesForLoadBalancer");
        request.addParameter("Version", "2012-06-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (disableAvailabilityZonesForLoadBalancerRequest.loadBalancerName() != null) {
            request.addParameter("LoadBalancerName", StringUtils.fromString((String)disableAvailabilityZonesForLoadBalancerRequest.loadBalancerName()));
        }
        if ((availabilityZonesList = disableAvailabilityZonesForLoadBalancerRequest.availabilityZones()) != null) {
            if (!availabilityZonesList.isEmpty()) {
                int availabilityZonesListIndex = 1;
                for (String availabilityZonesListValue : availabilityZonesList) {
                    if (availabilityZonesListValue != null) {
                        request.addParameter("AvailabilityZones.member." + availabilityZonesListIndex, StringUtils.fromString((String)availabilityZonesListValue));
                    }
                    ++availabilityZonesListIndex;
                }
            } else {
                request.addParameter("AvailabilityZones", "");
            }
        }
        return request;
    }
}

