/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancerPoliciesRequest;

public class DescribeLoadBalancerPoliciesRequestMarshaller
implements Marshaller<Request<DescribeLoadBalancerPoliciesRequest>, DescribeLoadBalancerPoliciesRequest> {
    public Request<DescribeLoadBalancerPoliciesRequest> marshall(DescribeLoadBalancerPoliciesRequest describeLoadBalancerPoliciesRequest) {
        List<String> policyNamesList;
        if (describeLoadBalancerPoliciesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)describeLoadBalancerPoliciesRequest, "ElasticLoadBalancingClient");
        request.addParameter("Action", "DescribeLoadBalancerPolicies");
        request.addParameter("Version", "2012-06-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeLoadBalancerPoliciesRequest.loadBalancerName() != null) {
            request.addParameter("LoadBalancerName", StringUtils.fromString((String)describeLoadBalancerPoliciesRequest.loadBalancerName()));
        }
        if ((policyNamesList = describeLoadBalancerPoliciesRequest.policyNames()) != null) {
            if (!policyNamesList.isEmpty()) {
                int policyNamesListIndex = 1;
                for (String policyNamesListValue : policyNamesList) {
                    if (policyNamesListValue != null) {
                        request.addParameter("PolicyNames.member." + policyNamesListIndex, StringUtils.fromString((String)policyNamesListValue));
                    }
                    ++policyNamesListIndex;
                }
            } else {
                request.addParameter("PolicyNames", "");
            }
        }
        return request;
    }
}

