/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeInstanceHealthRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.Instance;

public class DescribeInstanceHealthRequestMarshaller
implements Marshaller<Request<DescribeInstanceHealthRequest>, DescribeInstanceHealthRequest> {
    public Request<DescribeInstanceHealthRequest> marshall(DescribeInstanceHealthRequest describeInstanceHealthRequest) {
        List<Instance> instancesList;
        if (describeInstanceHealthRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)describeInstanceHealthRequest, "ElasticLoadBalancingClient");
        request.addParameter("Action", "DescribeInstanceHealth");
        request.addParameter("Version", "2012-06-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeInstanceHealthRequest.loadBalancerName() != null) {
            request.addParameter("LoadBalancerName", StringUtils.fromString((String)describeInstanceHealthRequest.loadBalancerName()));
        }
        if ((instancesList = describeInstanceHealthRequest.instances()) != null) {
            if (!instancesList.isEmpty()) {
                int instancesListIndex = 1;
                for (Instance instancesListValue : instancesList) {
                    if (instancesListValue.instanceId() != null) {
                        request.addParameter("Instances.member." + instancesListIndex + ".InstanceId", StringUtils.fromString((String)instancesListValue.instanceId()));
                    }
                    ++instancesListIndex;
                }
            } else {
                request.addParameter("Instances", "");
            }
        }
        return request;
    }
}

