/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.elasticloadbalancing.model.CreateLoadBalancerListenersRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.Listener;

public class CreateLoadBalancerListenersRequestMarshaller
implements Marshaller<Request<CreateLoadBalancerListenersRequest>, CreateLoadBalancerListenersRequest> {
    public Request<CreateLoadBalancerListenersRequest> marshall(CreateLoadBalancerListenersRequest createLoadBalancerListenersRequest) {
        List<Listener> listenersList;
        if (createLoadBalancerListenersRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)createLoadBalancerListenersRequest, "ElasticLoadBalancingClient");
        request.addParameter("Action", "CreateLoadBalancerListeners");
        request.addParameter("Version", "2012-06-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createLoadBalancerListenersRequest.loadBalancerName() != null) {
            request.addParameter("LoadBalancerName", StringUtils.fromString((String)createLoadBalancerListenersRequest.loadBalancerName()));
        }
        if ((listenersList = createLoadBalancerListenersRequest.listeners()) != null) {
            if (!listenersList.isEmpty()) {
                int listenersListIndex = 1;
                for (Listener listenersListValue : listenersList) {
                    if (listenersListValue.protocol() != null) {
                        request.addParameter("Listeners.member." + listenersListIndex + ".Protocol", StringUtils.fromString((String)listenersListValue.protocol()));
                    }
                    if (listenersListValue.loadBalancerPort() != null) {
                        request.addParameter("Listeners.member." + listenersListIndex + ".LoadBalancerPort", StringUtils.fromInteger((Integer)listenersListValue.loadBalancerPort()));
                    }
                    if (listenersListValue.instanceProtocol() != null) {
                        request.addParameter("Listeners.member." + listenersListIndex + ".InstanceProtocol", StringUtils.fromString((String)listenersListValue.instanceProtocol()));
                    }
                    if (listenersListValue.instancePort() != null) {
                        request.addParameter("Listeners.member." + listenersListIndex + ".InstancePort", StringUtils.fromInteger((Integer)listenersListValue.instancePort()));
                    }
                    if (listenersListValue.sslCertificateId() != null) {
                        request.addParameter("Listeners.member." + listenersListIndex + ".SSLCertificateId", StringUtils.fromString((String)listenersListValue.sslCertificateId()));
                    }
                    ++listenersListIndex;
                }
            } else {
                request.addParameter("Listeners", "");
            }
        }
        return request;
    }
}

