/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Listener
implements ToCopyableBuilder<Builder, Listener> {
    private final String protocol;
    private final Integer loadBalancerPort;
    private final String instanceProtocol;
    private final Integer instancePort;
    private final String sslCertificateId;

    private Listener(BuilderImpl builder) {
        this.protocol = builder.protocol;
        this.loadBalancerPort = builder.loadBalancerPort;
        this.instanceProtocol = builder.instanceProtocol;
        this.instancePort = builder.instancePort;
        this.sslCertificateId = builder.sslCertificateId;
    }

    public String protocol() {
        return this.protocol;
    }

    public Integer loadBalancerPort() {
        return this.loadBalancerPort;
    }

    public String instanceProtocol() {
        return this.instanceProtocol;
    }

    public Integer instancePort() {
        return this.instancePort;
    }

    public String sslCertificateId() {
        return this.sslCertificateId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.protocol());
        hashCode = 31 * hashCode + Objects.hashCode(this.loadBalancerPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceProtocol());
        hashCode = 31 * hashCode + Objects.hashCode(this.instancePort());
        hashCode = 31 * hashCode + Objects.hashCode(this.sslCertificateId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Listener)) {
            return false;
        }
        Listener other = (Listener)obj;
        return Objects.equals(this.protocol(), other.protocol()) && Objects.equals(this.loadBalancerPort(), other.loadBalancerPort()) && Objects.equals(this.instanceProtocol(), other.instanceProtocol()) && Objects.equals(this.instancePort(), other.instancePort()) && Objects.equals(this.sslCertificateId(), other.sslCertificateId());
    }

    public String toString() {
        return ToString.builder((String)"Listener").add("Protocol", (Object)this.protocol()).add("LoadBalancerPort", (Object)this.loadBalancerPort()).add("InstanceProtocol", (Object)this.instanceProtocol()).add("InstancePort", (Object)this.instancePort()).add("SSLCertificateId", (Object)this.sslCertificateId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Protocol": {
                return Optional.of(clazz.cast(this.protocol()));
            }
            case "LoadBalancerPort": {
                return Optional.of(clazz.cast(this.loadBalancerPort()));
            }
            case "InstanceProtocol": {
                return Optional.of(clazz.cast(this.instanceProtocol()));
            }
            case "InstancePort": {
                return Optional.of(clazz.cast(this.instancePort()));
            }
            case "SSLCertificateId": {
                return Optional.of(clazz.cast(this.sslCertificateId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String protocol;
        private Integer loadBalancerPort;
        private String instanceProtocol;
        private Integer instancePort;
        private String sslCertificateId;

        private BuilderImpl() {
        }

        private BuilderImpl(Listener model) {
            this.protocol(model.protocol);
            this.loadBalancerPort(model.loadBalancerPort);
            this.instanceProtocol(model.instanceProtocol);
            this.instancePort(model.instancePort);
            this.sslCertificateId(model.sslCertificateId);
        }

        public final String getProtocol() {
            return this.protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public final Integer getLoadBalancerPort() {
            return this.loadBalancerPort;
        }

        @Override
        public final Builder loadBalancerPort(Integer loadBalancerPort) {
            this.loadBalancerPort = loadBalancerPort;
            return this;
        }

        public final void setLoadBalancerPort(Integer loadBalancerPort) {
            this.loadBalancerPort = loadBalancerPort;
        }

        public final String getInstanceProtocol() {
            return this.instanceProtocol;
        }

        @Override
        public final Builder instanceProtocol(String instanceProtocol) {
            this.instanceProtocol = instanceProtocol;
            return this;
        }

        public final void setInstanceProtocol(String instanceProtocol) {
            this.instanceProtocol = instanceProtocol;
        }

        public final Integer getInstancePort() {
            return this.instancePort;
        }

        @Override
        public final Builder instancePort(Integer instancePort) {
            this.instancePort = instancePort;
            return this;
        }

        public final void setInstancePort(Integer instancePort) {
            this.instancePort = instancePort;
        }

        public final String getSSLCertificateId() {
            return this.sslCertificateId;
        }

        @Override
        public final Builder sslCertificateId(String sslCertificateId) {
            this.sslCertificateId = sslCertificateId;
            return this;
        }

        public final void setSSLCertificateId(String sslCertificateId) {
            this.sslCertificateId = sslCertificateId;
        }

        public Listener build() {
            return new Listener(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Listener> {
        public Builder protocol(String var1);

        public Builder loadBalancerPort(Integer var1);

        public Builder instanceProtocol(String var1);

        public Builder instancePort(Integer var1);

        public Builder sslCertificateId(String var1);
    }
}

