/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.model.Tag;
import software.amazon.awssdk.services.elasticloadbalancing.model.TagDescription;
import software.amazon.awssdk.services.elasticloadbalancing.transform.TagUnmarshaller;

public class TagDescriptionUnmarshaller
implements Unmarshaller<TagDescription, StaxUnmarshallerContext> {
    private static final TagDescriptionUnmarshaller INSTANCE = new TagDescriptionUnmarshaller();

    public TagDescription unmarshall(StaxUnmarshallerContext context) throws Exception {
        TagDescription.Builder tagDescription;
        block6: {
            tagDescription = TagDescription.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<Tag> tags = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    tagDescription.tags(tags);
                    break block6;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("LoadBalancerName", targetDepth)) {
                        tagDescription.loadBalancerName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Tags", targetDepth)) {
                        tags = new ArrayList<Tag>();
                        continue;
                    }
                    if (!context.testExpression("Tags/member", targetDepth)) continue;
                    tags.add(TagUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            tagDescription.tags(tags);
        }
        return (TagDescription)tagDescription.build();
    }

    public static TagDescriptionUnmarshaller getInstance() {
        return INSTANCE;
    }
}

