/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class HealthCheck
implements ToCopyableBuilder<Builder, HealthCheck> {
    private final String target;
    private final Integer interval;
    private final Integer timeout;
    private final Integer unhealthyThreshold;
    private final Integer healthyThreshold;

    private HealthCheck(BuilderImpl builder) {
        this.target = builder.target;
        this.interval = builder.interval;
        this.timeout = builder.timeout;
        this.unhealthyThreshold = builder.unhealthyThreshold;
        this.healthyThreshold = builder.healthyThreshold;
    }

    public String target() {
        return this.target;
    }

    public Integer interval() {
        return this.interval;
    }

    public Integer timeout() {
        return this.timeout;
    }

    public Integer unhealthyThreshold() {
        return this.unhealthyThreshold;
    }

    public Integer healthyThreshold() {
        return this.healthyThreshold;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.target());
        hashCode = 31 * hashCode + Objects.hashCode(this.interval());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.unhealthyThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthyThreshold());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HealthCheck)) {
            return false;
        }
        HealthCheck other = (HealthCheck)obj;
        return Objects.equals(this.target(), other.target()) && Objects.equals(this.interval(), other.interval()) && Objects.equals(this.timeout(), other.timeout()) && Objects.equals(this.unhealthyThreshold(), other.unhealthyThreshold()) && Objects.equals(this.healthyThreshold(), other.healthyThreshold());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.target() != null) {
            sb.append("Target: ").append(this.target()).append(",");
        }
        if (this.interval() != null) {
            sb.append("Interval: ").append(this.interval()).append(",");
        }
        if (this.timeout() != null) {
            sb.append("Timeout: ").append(this.timeout()).append(",");
        }
        if (this.unhealthyThreshold() != null) {
            sb.append("UnhealthyThreshold: ").append(this.unhealthyThreshold()).append(",");
        }
        if (this.healthyThreshold() != null) {
            sb.append("HealthyThreshold: ").append(this.healthyThreshold()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Target": {
                return Optional.of(clazz.cast(this.target()));
            }
            case "Interval": {
                return Optional.of(clazz.cast(this.interval()));
            }
            case "Timeout": {
                return Optional.of(clazz.cast(this.timeout()));
            }
            case "UnhealthyThreshold": {
                return Optional.of(clazz.cast(this.unhealthyThreshold()));
            }
            case "HealthyThreshold": {
                return Optional.of(clazz.cast(this.healthyThreshold()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String target;
        private Integer interval;
        private Integer timeout;
        private Integer unhealthyThreshold;
        private Integer healthyThreshold;

        private BuilderImpl() {
        }

        private BuilderImpl(HealthCheck model) {
            this.target(model.target);
            this.interval(model.interval);
            this.timeout(model.timeout);
            this.unhealthyThreshold(model.unhealthyThreshold);
            this.healthyThreshold(model.healthyThreshold);
        }

        public final String getTarget() {
            return this.target;
        }

        @Override
        public final Builder target(String target) {
            this.target = target;
            return this;
        }

        public final void setTarget(String target) {
            this.target = target;
        }

        public final Integer getInterval() {
            return this.interval;
        }

        @Override
        public final Builder interval(Integer interval) {
            this.interval = interval;
            return this;
        }

        public final void setInterval(Integer interval) {
            this.interval = interval;
        }

        public final Integer getTimeout() {
            return this.timeout;
        }

        @Override
        public final Builder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public final void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        public final Integer getUnhealthyThreshold() {
            return this.unhealthyThreshold;
        }

        @Override
        public final Builder unhealthyThreshold(Integer unhealthyThreshold) {
            this.unhealthyThreshold = unhealthyThreshold;
            return this;
        }

        public final void setUnhealthyThreshold(Integer unhealthyThreshold) {
            this.unhealthyThreshold = unhealthyThreshold;
        }

        public final Integer getHealthyThreshold() {
            return this.healthyThreshold;
        }

        @Override
        public final Builder healthyThreshold(Integer healthyThreshold) {
            this.healthyThreshold = healthyThreshold;
            return this;
        }

        public final void setHealthyThreshold(Integer healthyThreshold) {
            this.healthyThreshold = healthyThreshold;
        }

        public HealthCheck build() {
            return new HealthCheck(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, HealthCheck> {
        public Builder target(String var1);

        public Builder interval(Integer var1);

        public Builder timeout(Integer var1);

        public Builder unhealthyThreshold(Integer var1);

        public Builder healthyThreshold(Integer var1);
    }
}

