/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.elasticloadbalancing.model.ElasticLoadBalancingRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.SecurityGroupsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ApplySecurityGroupsToLoadBalancerRequest
extends ElasticLoadBalancingRequest
implements ToCopyableBuilder<Builder, ApplySecurityGroupsToLoadBalancerRequest> {
    private final String loadBalancerName;
    private final List<String> securityGroups;

    private ApplySecurityGroupsToLoadBalancerRequest(BuilderImpl builder) {
        super(builder);
        this.loadBalancerName = builder.loadBalancerName;
        this.securityGroups = builder.securityGroups;
    }

    public String loadBalancerName() {
        return this.loadBalancerName;
    }

    public List<String> securityGroups() {
        return this.securityGroups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.loadBalancerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityGroups());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplySecurityGroupsToLoadBalancerRequest)) {
            return false;
        }
        ApplySecurityGroupsToLoadBalancerRequest other = (ApplySecurityGroupsToLoadBalancerRequest)((Object)obj);
        return Objects.equals(this.loadBalancerName(), other.loadBalancerName()) && Objects.equals(this.securityGroups(), other.securityGroups());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.loadBalancerName() != null) {
            sb.append("LoadBalancerName: ").append(this.loadBalancerName()).append(",");
        }
        if (this.securityGroups() != null) {
            sb.append("SecurityGroups: ").append(this.securityGroups()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LoadBalancerName": {
                return Optional.of(clazz.cast(this.loadBalancerName()));
            }
            case "SecurityGroups": {
                return Optional.of(clazz.cast(this.securityGroups()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElasticLoadBalancingRequest.BuilderImpl
    implements Builder {
        private String loadBalancerName;
        private List<String> securityGroups;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplySecurityGroupsToLoadBalancerRequest model) {
            this.loadBalancerName(model.loadBalancerName);
            this.securityGroups(model.securityGroups);
        }

        public final String getLoadBalancerName() {
            return this.loadBalancerName;
        }

        @Override
        public final Builder loadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
            return this;
        }

        public final void setLoadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
        }

        public final Collection<String> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupsCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String ... securityGroups) {
            this.securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupsCopier.copy(securityGroups);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ApplySecurityGroupsToLoadBalancerRequest build() {
            return new ApplySecurityGroupsToLoadBalancerRequest(this);
        }
    }

    public static interface Builder
    extends ElasticLoadBalancingRequest.Builder,
    CopyableBuilder<Builder, ApplySecurityGroupsToLoadBalancerRequest> {
        public Builder loadBalancerName(String var1);

        public Builder securityGroups(Collection<String> var1);

        public Builder securityGroups(String ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

