/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.elasticloadbalancing.model.CreateLoadBalancerPolicyRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.PolicyAttribute;

public class CreateLoadBalancerPolicyRequestMarshaller
implements Marshaller<Request<CreateLoadBalancerPolicyRequest>, CreateLoadBalancerPolicyRequest> {
    public Request<CreateLoadBalancerPolicyRequest> marshall(CreateLoadBalancerPolicyRequest createLoadBalancerPolicyRequest) {
        List<PolicyAttribute> policyAttributesList;
        if (createLoadBalancerPolicyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createLoadBalancerPolicyRequest, "ElasticLoadBalancingClient");
        request.addParameter("Action", "CreateLoadBalancerPolicy");
        request.addParameter("Version", "2012-06-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createLoadBalancerPolicyRequest.loadBalancerName() != null) {
            request.addParameter("LoadBalancerName", StringUtils.fromString((String)createLoadBalancerPolicyRequest.loadBalancerName()));
        }
        if (createLoadBalancerPolicyRequest.policyName() != null) {
            request.addParameter("PolicyName", StringUtils.fromString((String)createLoadBalancerPolicyRequest.policyName()));
        }
        if (createLoadBalancerPolicyRequest.policyTypeName() != null) {
            request.addParameter("PolicyTypeName", StringUtils.fromString((String)createLoadBalancerPolicyRequest.policyTypeName()));
        }
        if ((policyAttributesList = createLoadBalancerPolicyRequest.policyAttributes()) != null) {
            if (!policyAttributesList.isEmpty()) {
                int policyAttributesListIndex = 1;
                for (PolicyAttribute policyAttributesListValue : policyAttributesList) {
                    if (policyAttributesListValue.attributeName() != null) {
                        request.addParameter("PolicyAttributes.member." + policyAttributesListIndex + ".AttributeName", StringUtils.fromString((String)policyAttributesListValue.attributeName()));
                    }
                    if (policyAttributesListValue.attributeValue() != null) {
                        request.addParameter("PolicyAttributes.member." + policyAttributesListIndex + ".AttributeValue", StringUtils.fromString((String)policyAttributesListValue.attributeValue()));
                    }
                    ++policyAttributesListIndex;
                }
            } else {
                request.addParameter("PolicyAttributes", "");
            }
        }
        return request;
    }
}

