/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.elasticloadbalancing.model.LoadBalancerDescription;
import software.amazon.awssdk.services.elasticloadbalancing.model.LoadBalancerDescriptionsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeLoadBalancersResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeLoadBalancersResponse> {
    private final List<LoadBalancerDescription> loadBalancerDescriptions;
    private final String nextMarker;

    private DescribeLoadBalancersResponse(BuilderImpl builder) {
        this.loadBalancerDescriptions = builder.loadBalancerDescriptions;
        this.nextMarker = builder.nextMarker;
    }

    public List<LoadBalancerDescription> loadBalancerDescriptions() {
        return this.loadBalancerDescriptions;
    }

    public String nextMarker() {
        return this.nextMarker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.loadBalancerDescriptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextMarker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLoadBalancersResponse)) {
            return false;
        }
        DescribeLoadBalancersResponse other = (DescribeLoadBalancersResponse)((Object)obj);
        return Objects.equals(this.loadBalancerDescriptions(), other.loadBalancerDescriptions()) && Objects.equals(this.nextMarker(), other.nextMarker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.loadBalancerDescriptions() != null) {
            sb.append("LoadBalancerDescriptions: ").append(this.loadBalancerDescriptions()).append(",");
        }
        if (this.nextMarker() != null) {
            sb.append("NextMarker: ").append(this.nextMarker()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LoadBalancerDescriptions": {
                return Optional.of(clazz.cast(this.loadBalancerDescriptions()));
            }
            case "NextMarker": {
                return Optional.of(clazz.cast(this.nextMarker()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<LoadBalancerDescription> loadBalancerDescriptions;
        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLoadBalancersResponse model) {
            this.loadBalancerDescriptions(model.loadBalancerDescriptions);
            this.nextMarker(model.nextMarker);
        }

        public final Collection<LoadBalancerDescription.Builder> getLoadBalancerDescriptions() {
            return this.loadBalancerDescriptions != null ? (Collection)this.loadBalancerDescriptions.stream().map(LoadBalancerDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder loadBalancerDescriptions(Collection<LoadBalancerDescription> loadBalancerDescriptions) {
            this.loadBalancerDescriptions = LoadBalancerDescriptionsCopier.copy(loadBalancerDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancerDescriptions(LoadBalancerDescription ... loadBalancerDescriptions) {
            this.loadBalancerDescriptions(Arrays.asList(loadBalancerDescriptions));
            return this;
        }

        public final void setLoadBalancerDescriptions(Collection<LoadBalancerDescription.BuilderImpl> loadBalancerDescriptions) {
            this.loadBalancerDescriptions = LoadBalancerDescriptionsCopier.copyFromBuilder(loadBalancerDescriptions);
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        public DescribeLoadBalancersResponse build() {
            return new DescribeLoadBalancersResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeLoadBalancersResponse> {
        public Builder loadBalancerDescriptions(Collection<LoadBalancerDescription> var1);

        public Builder loadBalancerDescriptions(LoadBalancerDescription ... var1);

        public Builder nextMarker(String var1);
    }
}

