/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.elasticloadbalancing.model.CreateLoadBalancerRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.Listener;
import software.amazon.awssdk.services.elasticloadbalancing.model.Tag;

public class CreateLoadBalancerRequestMarshaller
implements Marshaller<Request<CreateLoadBalancerRequest>, CreateLoadBalancerRequest> {
    /*
     * WARNING - void declaration
     */
    public Request<CreateLoadBalancerRequest> marshall(CreateLoadBalancerRequest createLoadBalancerRequest) {
        List<Tag> list;
        List<String> list2;
        List<String> subnetsList;
        List<String> availabilityZonesList;
        List<Listener> listenersList;
        if (createLoadBalancerRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createLoadBalancerRequest, "ElasticLoadBalancingClient");
        request.addParameter("Action", "CreateLoadBalancer");
        request.addParameter("Version", "2012-06-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createLoadBalancerRequest.loadBalancerName() != null) {
            request.addParameter("LoadBalancerName", StringUtils.fromString((String)createLoadBalancerRequest.loadBalancerName()));
        }
        if ((listenersList = createLoadBalancerRequest.listeners()) != null) {
            if (!listenersList.isEmpty()) {
                int listenersListIndex = 1;
                for (Listener listener : listenersList) {
                    if (listener.protocol() != null) {
                        request.addParameter("Listeners.member." + listenersListIndex + ".Protocol", StringUtils.fromString((String)listener.protocol()));
                    }
                    if (listener.loadBalancerPort() != null) {
                        request.addParameter("Listeners.member." + listenersListIndex + ".LoadBalancerPort", StringUtils.fromInteger((Integer)listener.loadBalancerPort()));
                    }
                    if (listener.instanceProtocol() != null) {
                        request.addParameter("Listeners.member." + listenersListIndex + ".InstanceProtocol", StringUtils.fromString((String)listener.instanceProtocol()));
                    }
                    if (listener.instancePort() != null) {
                        request.addParameter("Listeners.member." + listenersListIndex + ".InstancePort", StringUtils.fromInteger((Integer)listener.instancePort()));
                    }
                    if (listener.sslCertificateId() != null) {
                        request.addParameter("Listeners.member." + listenersListIndex + ".SSLCertificateId", StringUtils.fromString((String)listener.sslCertificateId()));
                    }
                    ++listenersListIndex;
                }
            } else {
                request.addParameter("Listeners", "");
            }
        }
        if ((availabilityZonesList = createLoadBalancerRequest.availabilityZones()) != null) {
            if (!availabilityZonesList.isEmpty()) {
                int availabilityZonesListIndex = 1;
                for (String string : availabilityZonesList) {
                    if (string != null) {
                        request.addParameter("AvailabilityZones.member." + availabilityZonesListIndex, StringUtils.fromString((String)string));
                    }
                    ++availabilityZonesListIndex;
                }
            } else {
                request.addParameter("AvailabilityZones", "");
            }
        }
        if ((subnetsList = createLoadBalancerRequest.subnets()) != null) {
            if (!subnetsList.isEmpty()) {
                boolean bl = true;
                for (String string : subnetsList) {
                    void var6_12;
                    if (string != null) {
                        request.addParameter("Subnets.member." + (int)var6_12, StringUtils.fromString((String)string));
                    }
                    ++var6_12;
                }
            } else {
                request.addParameter("Subnets", "");
            }
        }
        if ((list2 = createLoadBalancerRequest.securityGroups()) != null) {
            if (!list2.isEmpty()) {
                boolean bl = true;
                for (String securityGroupsListValue : list2) {
                    void var7_18;
                    if (securityGroupsListValue != null) {
                        request.addParameter("SecurityGroups.member." + (int)var7_18, StringUtils.fromString((String)securityGroupsListValue));
                    }
                    ++var7_18;
                }
            } else {
                request.addParameter("SecurityGroups", "");
            }
        }
        if (createLoadBalancerRequest.scheme() != null) {
            request.addParameter("Scheme", StringUtils.fromString((String)createLoadBalancerRequest.scheme()));
        }
        if ((list = createLoadBalancerRequest.tags()) != null) {
            if (!list.isEmpty()) {
                boolean bl = true;
                for (Tag tagsListValue : list) {
                    void var8_24;
                    if (tagsListValue.key() != null) {
                        request.addParameter("Tags.member." + (int)var8_24 + ".Key", StringUtils.fromString((String)tagsListValue.key()));
                    }
                    if (tagsListValue.value() != null) {
                        request.addParameter("Tags.member." + (int)var8_24 + ".Value", StringUtils.fromString((String)tagsListValue.value()));
                    }
                    ++var8_24;
                }
            } else {
                request.addParameter("Tags", "");
            }
        }
        return request;
    }
}

