/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Optional;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SourceSecurityGroup
implements ToCopyableBuilder<Builder, SourceSecurityGroup> {
    private final String ownerAlias;
    private final String groupName;

    private SourceSecurityGroup(BuilderImpl builder) {
        this.ownerAlias = builder.ownerAlias;
        this.groupName = builder.groupName;
    }

    public String ownerAlias() {
        return this.ownerAlias;
    }

    public String groupName() {
        return this.groupName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.ownerAlias() == null ? 0 : this.ownerAlias().hashCode());
        hashCode = 31 * hashCode + (this.groupName() == null ? 0 : this.groupName().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceSecurityGroup)) {
            return false;
        }
        SourceSecurityGroup other = (SourceSecurityGroup)obj;
        if (other.ownerAlias() == null ^ this.ownerAlias() == null) {
            return false;
        }
        if (other.ownerAlias() != null && !other.ownerAlias().equals(this.ownerAlias())) {
            return false;
        }
        if (other.groupName() == null ^ this.groupName() == null) {
            return false;
        }
        return other.groupName() == null || other.groupName().equals(this.groupName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.ownerAlias() != null) {
            sb.append("OwnerAlias: ").append(this.ownerAlias()).append(",");
        }
        if (this.groupName() != null) {
            sb.append("GroupName: ").append(this.groupName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OwnerAlias": {
                return Optional.of(clazz.cast(this.ownerAlias()));
            }
            case "GroupName": {
                return Optional.of(clazz.cast(this.groupName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String ownerAlias;
        private String groupName;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceSecurityGroup model) {
            this.ownerAlias(model.ownerAlias);
            this.groupName(model.groupName);
        }

        public final String getOwnerAlias() {
            return this.ownerAlias;
        }

        @Override
        public final Builder ownerAlias(String ownerAlias) {
            this.ownerAlias = ownerAlias;
            return this;
        }

        public final void setOwnerAlias(String ownerAlias) {
            this.ownerAlias = ownerAlias;
        }

        public final String getGroupName() {
            return this.groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public SourceSecurityGroup build() {
            return new SourceSecurityGroup(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SourceSecurityGroup> {
        public Builder ownerAlias(String var1);

        public Builder groupName(String var1);
    }
}

