/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.services.elasticloadbalancing.model.PolicyAttributeDescription;
import software.amazon.awssdk.services.elasticloadbalancing.model.PolicyAttributeDescriptionsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PolicyDescription
implements ToCopyableBuilder<Builder, PolicyDescription> {
    private final String policyName;
    private final String policyTypeName;
    private final List<PolicyAttributeDescription> policyAttributeDescriptions;

    private PolicyDescription(BuilderImpl builder) {
        this.policyName = builder.policyName;
        this.policyTypeName = builder.policyTypeName;
        this.policyAttributeDescriptions = builder.policyAttributeDescriptions;
    }

    public String policyName() {
        return this.policyName;
    }

    public String policyTypeName() {
        return this.policyTypeName;
    }

    public List<PolicyAttributeDescription> policyAttributeDescriptions() {
        return this.policyAttributeDescriptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.policyName() == null ? 0 : this.policyName().hashCode());
        hashCode = 31 * hashCode + (this.policyTypeName() == null ? 0 : this.policyTypeName().hashCode());
        hashCode = 31 * hashCode + (this.policyAttributeDescriptions() == null ? 0 : this.policyAttributeDescriptions().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PolicyDescription)) {
            return false;
        }
        PolicyDescription other = (PolicyDescription)obj;
        if (other.policyName() == null ^ this.policyName() == null) {
            return false;
        }
        if (other.policyName() != null && !other.policyName().equals(this.policyName())) {
            return false;
        }
        if (other.policyTypeName() == null ^ this.policyTypeName() == null) {
            return false;
        }
        if (other.policyTypeName() != null && !other.policyTypeName().equals(this.policyTypeName())) {
            return false;
        }
        if (other.policyAttributeDescriptions() == null ^ this.policyAttributeDescriptions() == null) {
            return false;
        }
        return other.policyAttributeDescriptions() == null || other.policyAttributeDescriptions().equals(this.policyAttributeDescriptions());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.policyName() != null) {
            sb.append("PolicyName: ").append(this.policyName()).append(",");
        }
        if (this.policyTypeName() != null) {
            sb.append("PolicyTypeName: ").append(this.policyTypeName()).append(",");
        }
        if (this.policyAttributeDescriptions() != null) {
            sb.append("PolicyAttributeDescriptions: ").append(this.policyAttributeDescriptions()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String policyName;
        private String policyTypeName;
        private List<PolicyAttributeDescription> policyAttributeDescriptions;

        private BuilderImpl() {
        }

        private BuilderImpl(PolicyDescription model) {
            this.setPolicyName(model.policyName);
            this.setPolicyTypeName(model.policyTypeName);
            this.setPolicyAttributeDescriptions(model.policyAttributeDescriptions);
        }

        public final String getPolicyName() {
            return this.policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        public final String getPolicyTypeName() {
            return this.policyTypeName;
        }

        @Override
        public final Builder policyTypeName(String policyTypeName) {
            this.policyTypeName = policyTypeName;
            return this;
        }

        public final void setPolicyTypeName(String policyTypeName) {
            this.policyTypeName = policyTypeName;
        }

        public final Collection<PolicyAttributeDescription> getPolicyAttributeDescriptions() {
            return this.policyAttributeDescriptions;
        }

        @Override
        public final Builder policyAttributeDescriptions(Collection<PolicyAttributeDescription> policyAttributeDescriptions) {
            this.policyAttributeDescriptions = PolicyAttributeDescriptionsCopier.copy(policyAttributeDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyAttributeDescriptions(PolicyAttributeDescription ... policyAttributeDescriptions) {
            this.policyAttributeDescriptions(Arrays.asList(policyAttributeDescriptions));
            return this;
        }

        public final void setPolicyAttributeDescriptions(Collection<PolicyAttributeDescription> policyAttributeDescriptions) {
            this.policyAttributeDescriptions = PolicyAttributeDescriptionsCopier.copy(policyAttributeDescriptions);
        }

        public PolicyDescription build() {
            return new PolicyDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PolicyDescription> {
        public Builder policyName(String var1);

        public Builder policyTypeName(String var1);

        public Builder policyAttributeDescriptions(Collection<PolicyAttributeDescription> var1);

        public Builder policyAttributeDescriptions(PolicyAttributeDescription ... var1);
    }
}

