/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.services.elasticloadbalancing.model.Listener;
import software.amazon.awssdk.services.elasticloadbalancing.model.PolicyNamesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListenerDescription
implements ToCopyableBuilder<Builder, ListenerDescription> {
    private final Listener listener;
    private final List<String> policyNames;

    private ListenerDescription(BuilderImpl builder) {
        this.listener = builder.listener;
        this.policyNames = builder.policyNames;
    }

    public Listener listener() {
        return this.listener;
    }

    public List<String> policyNames() {
        return this.policyNames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.listener() == null ? 0 : this.listener().hashCode());
        hashCode = 31 * hashCode + (this.policyNames() == null ? 0 : this.policyNames().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListenerDescription)) {
            return false;
        }
        ListenerDescription other = (ListenerDescription)obj;
        if (other.listener() == null ^ this.listener() == null) {
            return false;
        }
        if (other.listener() != null && !other.listener().equals(this.listener())) {
            return false;
        }
        if (other.policyNames() == null ^ this.policyNames() == null) {
            return false;
        }
        return other.policyNames() == null || other.policyNames().equals(this.policyNames());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.listener() != null) {
            sb.append("Listener: ").append(this.listener()).append(",");
        }
        if (this.policyNames() != null) {
            sb.append("PolicyNames: ").append(this.policyNames()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private Listener listener;
        private List<String> policyNames;

        private BuilderImpl() {
        }

        private BuilderImpl(ListenerDescription model) {
            this.setListener(model.listener);
            this.setPolicyNames(model.policyNames);
        }

        public final Listener getListener() {
            return this.listener;
        }

        @Override
        public final Builder listener(Listener listener) {
            this.listener = listener;
            return this;
        }

        public final void setListener(Listener listener) {
            this.listener = listener;
        }

        public final Collection<String> getPolicyNames() {
            return this.policyNames;
        }

        @Override
        public final Builder policyNames(Collection<String> policyNames) {
            this.policyNames = PolicyNamesCopier.copy(policyNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyNames(String ... policyNames) {
            this.policyNames(Arrays.asList(policyNames));
            return this;
        }

        public final void setPolicyNames(Collection<String> policyNames) {
            this.policyNames = PolicyNamesCopier.copy(policyNames);
        }

        public ListenerDescription build() {
            return new ListenerDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListenerDescription> {
        public Builder listener(Listener var1);

        public Builder policyNames(Collection<String> var1);

        public Builder policyNames(String ... var1);
    }
}

