/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.HealthCheck;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ConfigureHealthCheckRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ConfigureHealthCheckRequest> {
    private final String loadBalancerName;
    private final HealthCheck healthCheck;

    private ConfigureHealthCheckRequest(BuilderImpl builder) {
        this.loadBalancerName = builder.loadBalancerName;
        this.healthCheck = builder.healthCheck;
    }

    public String loadBalancerName() {
        return this.loadBalancerName;
    }

    public HealthCheck healthCheck() {
        return this.healthCheck;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.loadBalancerName() == null ? 0 : this.loadBalancerName().hashCode());
        hashCode = 31 * hashCode + (this.healthCheck() == null ? 0 : this.healthCheck().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigureHealthCheckRequest)) {
            return false;
        }
        ConfigureHealthCheckRequest other = (ConfigureHealthCheckRequest)((Object)obj);
        if (other.loadBalancerName() == null ^ this.loadBalancerName() == null) {
            return false;
        }
        if (other.loadBalancerName() != null && !other.loadBalancerName().equals(this.loadBalancerName())) {
            return false;
        }
        if (other.healthCheck() == null ^ this.healthCheck() == null) {
            return false;
        }
        return other.healthCheck() == null || other.healthCheck().equals(this.healthCheck());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.loadBalancerName() != null) {
            sb.append("LoadBalancerName: ").append(this.loadBalancerName()).append(",");
        }
        if (this.healthCheck() != null) {
            sb.append("HealthCheck: ").append(this.healthCheck()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String loadBalancerName;
        private HealthCheck healthCheck;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigureHealthCheckRequest model) {
            this.setLoadBalancerName(model.loadBalancerName);
            this.setHealthCheck(model.healthCheck);
        }

        public final String getLoadBalancerName() {
            return this.loadBalancerName;
        }

        @Override
        public final Builder loadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
            return this;
        }

        public final void setLoadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
        }

        public final HealthCheck getHealthCheck() {
            return this.healthCheck;
        }

        @Override
        public final Builder healthCheck(HealthCheck healthCheck) {
            this.healthCheck = healthCheck;
            return this;
        }

        public final void setHealthCheck(HealthCheck healthCheck) {
            this.healthCheck = healthCheck;
        }

        public ConfigureHealthCheckRequest build() {
            return new ConfigureHealthCheckRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ConfigureHealthCheckRequest> {
        public Builder loadBalancerName(String var1);

        public Builder healthCheck(HealthCheck var1);
    }
}

