/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.elasticloadbalancing.model.ElasticLoadBalancingRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SetLoadBalancerListenerSSLCertificateRequest
extends ElasticLoadBalancingRequest
implements ToCopyableBuilder<Builder, SetLoadBalancerListenerSSLCertificateRequest> {
    private final String loadBalancerName;
    private final Integer loadBalancerPort;
    private final String sslCertificateId;

    private SetLoadBalancerListenerSSLCertificateRequest(BuilderImpl builder) {
        super(builder);
        this.loadBalancerName = builder.loadBalancerName;
        this.loadBalancerPort = builder.loadBalancerPort;
        this.sslCertificateId = builder.sslCertificateId;
    }

    public String loadBalancerName() {
        return this.loadBalancerName;
    }

    public Integer loadBalancerPort() {
        return this.loadBalancerPort;
    }

    public String sslCertificateId() {
        return this.sslCertificateId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.loadBalancerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.loadBalancerPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.sslCertificateId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetLoadBalancerListenerSSLCertificateRequest)) {
            return false;
        }
        SetLoadBalancerListenerSSLCertificateRequest other = (SetLoadBalancerListenerSSLCertificateRequest)((Object)obj);
        return Objects.equals(this.loadBalancerName(), other.loadBalancerName()) && Objects.equals(this.loadBalancerPort(), other.loadBalancerPort()) && Objects.equals(this.sslCertificateId(), other.sslCertificateId());
    }

    public String toString() {
        return ToString.builder((String)"SetLoadBalancerListenerSSLCertificateRequest").add("LoadBalancerName", (Object)this.loadBalancerName()).add("LoadBalancerPort", (Object)this.loadBalancerPort()).add("SSLCertificateId", (Object)this.sslCertificateId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LoadBalancerName": {
                return Optional.of(clazz.cast(this.loadBalancerName()));
            }
            case "LoadBalancerPort": {
                return Optional.of(clazz.cast(this.loadBalancerPort()));
            }
            case "SSLCertificateId": {
                return Optional.of(clazz.cast(this.sslCertificateId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElasticLoadBalancingRequest.BuilderImpl
    implements Builder {
        private String loadBalancerName;
        private Integer loadBalancerPort;
        private String sslCertificateId;

        private BuilderImpl() {
        }

        private BuilderImpl(SetLoadBalancerListenerSSLCertificateRequest model) {
            super(model);
            this.loadBalancerName(model.loadBalancerName);
            this.loadBalancerPort(model.loadBalancerPort);
            this.sslCertificateId(model.sslCertificateId);
        }

        public final String getLoadBalancerName() {
            return this.loadBalancerName;
        }

        @Override
        public final Builder loadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
            return this;
        }

        public final void setLoadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
        }

        public final Integer getLoadBalancerPort() {
            return this.loadBalancerPort;
        }

        @Override
        public final Builder loadBalancerPort(Integer loadBalancerPort) {
            this.loadBalancerPort = loadBalancerPort;
            return this;
        }

        public final void setLoadBalancerPort(Integer loadBalancerPort) {
            this.loadBalancerPort = loadBalancerPort;
        }

        public final String getSSLCertificateId() {
            return this.sslCertificateId;
        }

        @Override
        public final Builder sslCertificateId(String sslCertificateId) {
            this.sslCertificateId = sslCertificateId;
            return this;
        }

        public final void setSSLCertificateId(String sslCertificateId) {
            this.sslCertificateId = sslCertificateId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public SetLoadBalancerListenerSSLCertificateRequest build() {
            return new SetLoadBalancerListenerSSLCertificateRequest(this);
        }
    }

    public static interface Builder
    extends ElasticLoadBalancingRequest.Builder,
    CopyableBuilder<Builder, SetLoadBalancerListenerSSLCertificateRequest> {
        public Builder loadBalancerName(String var1);

        public Builder loadBalancerPort(Integer var1);

        public Builder sslCertificateId(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

