/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.elasticloadbalancing.model.ElasticLoadBalancingResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.PolicyTypeDescription;
import software.amazon.awssdk.services.elasticloadbalancing.model.PolicyTypeDescriptionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeLoadBalancerPolicyTypesResponse
extends ElasticLoadBalancingResponse
implements ToCopyableBuilder<Builder, DescribeLoadBalancerPolicyTypesResponse> {
    private final List<PolicyTypeDescription> policyTypeDescriptions;

    private DescribeLoadBalancerPolicyTypesResponse(BuilderImpl builder) {
        super(builder);
        this.policyTypeDescriptions = builder.policyTypeDescriptions;
    }

    public List<PolicyTypeDescription> policyTypeDescriptions() {
        return this.policyTypeDescriptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.policyTypeDescriptions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLoadBalancerPolicyTypesResponse)) {
            return false;
        }
        DescribeLoadBalancerPolicyTypesResponse other = (DescribeLoadBalancerPolicyTypesResponse)((Object)obj);
        return Objects.equals(this.policyTypeDescriptions(), other.policyTypeDescriptions());
    }

    public String toString() {
        return ToString.builder((String)"DescribeLoadBalancerPolicyTypesResponse").add("PolicyTypeDescriptions", this.policyTypeDescriptions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PolicyTypeDescriptions": {
                return Optional.of(clazz.cast(this.policyTypeDescriptions()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElasticLoadBalancingResponse.BuilderImpl
    implements Builder {
        private List<PolicyTypeDescription> policyTypeDescriptions;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLoadBalancerPolicyTypesResponse model) {
            super(model);
            this.policyTypeDescriptions(model.policyTypeDescriptions);
        }

        public final Collection<PolicyTypeDescription.Builder> getPolicyTypeDescriptions() {
            return this.policyTypeDescriptions != null ? (Collection)this.policyTypeDescriptions.stream().map(PolicyTypeDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder policyTypeDescriptions(Collection<PolicyTypeDescription> policyTypeDescriptions) {
            this.policyTypeDescriptions = PolicyTypeDescriptionsCopier.copy(policyTypeDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyTypeDescriptions(PolicyTypeDescription ... policyTypeDescriptions) {
            this.policyTypeDescriptions(Arrays.asList(policyTypeDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyTypeDescriptions(Consumer<PolicyTypeDescription.Builder> ... policyTypeDescriptions) {
            this.policyTypeDescriptions(Stream.of(policyTypeDescriptions).map(c -> (PolicyTypeDescription)((PolicyTypeDescription.Builder)PolicyTypeDescription.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPolicyTypeDescriptions(Collection<PolicyTypeDescription.BuilderImpl> policyTypeDescriptions) {
            this.policyTypeDescriptions = PolicyTypeDescriptionsCopier.copyFromBuilder(policyTypeDescriptions);
        }

        @Override
        public DescribeLoadBalancerPolicyTypesResponse build() {
            return new DescribeLoadBalancerPolicyTypesResponse(this);
        }
    }

    public static interface Builder
    extends ElasticLoadBalancingResponse.Builder,
    CopyableBuilder<Builder, DescribeLoadBalancerPolicyTypesResponse> {
        public Builder policyTypeDescriptions(Collection<PolicyTypeDescription> var1);

        public Builder policyTypeDescriptions(PolicyTypeDescription ... var1);

        public Builder policyTypeDescriptions(Consumer<PolicyTypeDescription.Builder> ... var1);
    }
}

