/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.elasticloadbalancing.model.AccessLog;
import software.amazon.awssdk.services.elasticloadbalancing.model.AdditionalAttribute;
import software.amazon.awssdk.services.elasticloadbalancing.model.ConnectionDraining;
import software.amazon.awssdk.services.elasticloadbalancing.model.ConnectionSettings;
import software.amazon.awssdk.services.elasticloadbalancing.model.CrossZoneLoadBalancing;
import software.amazon.awssdk.services.elasticloadbalancing.model.LoadBalancerAttributes;
import software.amazon.awssdk.services.elasticloadbalancing.model.ModifyLoadBalancerAttributesRequest;
import software.amazon.awssdk.util.StringUtils;

public class ModifyLoadBalancerAttributesRequestMarshaller
implements Marshaller<Request<ModifyLoadBalancerAttributesRequest>, ModifyLoadBalancerAttributesRequest> {
    public Request<ModifyLoadBalancerAttributesRequest> marshall(ModifyLoadBalancerAttributesRequest modifyLoadBalancerAttributesRequest) {
        LoadBalancerAttributes loadBalancerAttributes;
        if (modifyLoadBalancerAttributesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyLoadBalancerAttributesRequest, "ElasticLoadBalancingClient");
        request.addParameter("Action", "ModifyLoadBalancerAttributes");
        request.addParameter("Version", "2012-06-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyLoadBalancerAttributesRequest.loadBalancerName() != null) {
            request.addParameter("LoadBalancerName", StringUtils.fromString((String)modifyLoadBalancerAttributesRequest.loadBalancerName()));
        }
        if ((loadBalancerAttributes = modifyLoadBalancerAttributesRequest.loadBalancerAttributes()) != null) {
            SdkInternalList additionalAttributesList;
            ConnectionSettings connectionSettings;
            ConnectionDraining connectionDraining;
            AccessLog accessLog;
            CrossZoneLoadBalancing crossZoneLoadBalancing = loadBalancerAttributes.crossZoneLoadBalancing();
            if (crossZoneLoadBalancing != null && crossZoneLoadBalancing.enabled() != null) {
                request.addParameter("LoadBalancerAttributes.CrossZoneLoadBalancing.Enabled", StringUtils.fromBoolean((Boolean)crossZoneLoadBalancing.enabled()));
            }
            if ((accessLog = loadBalancerAttributes.accessLog()) != null) {
                if (accessLog.enabled() != null) {
                    request.addParameter("LoadBalancerAttributes.AccessLog.Enabled", StringUtils.fromBoolean((Boolean)accessLog.enabled()));
                }
                if (accessLog.s3BucketName() != null) {
                    request.addParameter("LoadBalancerAttributes.AccessLog.S3BucketName", StringUtils.fromString((String)accessLog.s3BucketName()));
                }
                if (accessLog.emitInterval() != null) {
                    request.addParameter("LoadBalancerAttributes.AccessLog.EmitInterval", StringUtils.fromInteger((Integer)accessLog.emitInterval()));
                }
                if (accessLog.s3BucketPrefix() != null) {
                    request.addParameter("LoadBalancerAttributes.AccessLog.S3BucketPrefix", StringUtils.fromString((String)accessLog.s3BucketPrefix()));
                }
            }
            if ((connectionDraining = loadBalancerAttributes.connectionDraining()) != null) {
                if (connectionDraining.enabled() != null) {
                    request.addParameter("LoadBalancerAttributes.ConnectionDraining.Enabled", StringUtils.fromBoolean((Boolean)connectionDraining.enabled()));
                }
                if (connectionDraining.timeout() != null) {
                    request.addParameter("LoadBalancerAttributes.ConnectionDraining.Timeout", StringUtils.fromInteger((Integer)connectionDraining.timeout()));
                }
            }
            if ((connectionSettings = loadBalancerAttributes.connectionSettings()) != null && connectionSettings.idleTimeout() != null) {
                request.addParameter("LoadBalancerAttributes.ConnectionSettings.IdleTimeout", StringUtils.fromInteger((Integer)connectionSettings.idleTimeout()));
            }
            if (!(additionalAttributesList = (SdkInternalList)loadBalancerAttributes.additionalAttributes()).isEmpty() || !additionalAttributesList.isAutoConstruct()) {
                int additionalAttributesListIndex = 1;
                for (AdditionalAttribute additionalAttributesListValue : additionalAttributesList) {
                    if (additionalAttributesListValue.key() != null) {
                        request.addParameter("LoadBalancerAttributes.AdditionalAttributes.member." + additionalAttributesListIndex + ".Key", StringUtils.fromString((String)additionalAttributesListValue.key()));
                    }
                    if (additionalAttributesListValue.value() != null) {
                        request.addParameter("LoadBalancerAttributes.AdditionalAttributes.member." + additionalAttributesListIndex + ".Value", StringUtils.fromString((String)additionalAttributesListValue.value()));
                    }
                    ++additionalAttributesListIndex;
                }
            }
        }
        return request;
    }
}

