/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.model.AdditionalAttribute;
import software.amazon.awssdk.services.elasticloadbalancing.model.LoadBalancerAttributes;
import software.amazon.awssdk.services.elasticloadbalancing.transform.AccessLogUnmarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.AdditionalAttributeUnmarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.ConnectionDrainingUnmarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.ConnectionSettingsUnmarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.transform.CrossZoneLoadBalancingUnmarshaller;

public class LoadBalancerAttributesUnmarshaller
implements Unmarshaller<LoadBalancerAttributes, StaxUnmarshallerContext> {
    private static LoadBalancerAttributesUnmarshaller INSTANCE;

    public LoadBalancerAttributes unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        LoadBalancerAttributes.Builder loadBalancerAttributes = LoadBalancerAttributes.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("CrossZoneLoadBalancing", targetDepth)) {
                    loadBalancerAttributes.crossZoneLoadBalancing(CrossZoneLoadBalancingUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("AccessLog", targetDepth)) {
                    loadBalancerAttributes.accessLog(AccessLogUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ConnectionDraining", targetDepth)) {
                    loadBalancerAttributes.connectionDraining(ConnectionDrainingUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ConnectionSettings", targetDepth)) {
                    loadBalancerAttributes.connectionSettings(ConnectionSettingsUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("AdditionalAttributes", targetDepth)) {
                    loadBalancerAttributes.additionalAttributes(new ArrayList<AdditionalAttribute>());
                    continue;
                }
                if (!context.testExpression("AdditionalAttributes/member", targetDepth)) continue;
                loadBalancerAttributes.additionalAttributes(AdditionalAttributeUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (LoadBalancerAttributes)loadBalancerAttributes.build();
    }

    public static LoadBalancerAttributesUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new LoadBalancerAttributesUnmarshaller();
        }
        return INSTANCE;
    }
}

