/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.elasticloadbalancing.model.LoadBalancerNamesCopier;
import software.amazon.awssdk.services.elasticloadbalancing.model.TagKeyListCopier;
import software.amazon.awssdk.services.elasticloadbalancing.model.TagKeyOnly;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RemoveTagsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, RemoveTagsRequest> {
    private final List<String> loadBalancerNames;
    private final List<TagKeyOnly> tags;

    private RemoveTagsRequest(BuilderImpl builder) {
        this.loadBalancerNames = builder.loadBalancerNames;
        this.tags = builder.tags;
    }

    public List<String> loadBalancerNames() {
        return this.loadBalancerNames;
    }

    public List<TagKeyOnly> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.loadBalancerNames() == null ? 0 : this.loadBalancerNames().hashCode());
        hashCode = 31 * hashCode + (this.tags() == null ? 0 : this.tags().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemoveTagsRequest)) {
            return false;
        }
        RemoveTagsRequest other = (RemoveTagsRequest)((Object)obj);
        if (other.loadBalancerNames() == null ^ this.loadBalancerNames() == null) {
            return false;
        }
        if (other.loadBalancerNames() != null && !other.loadBalancerNames().equals(this.loadBalancerNames())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        return other.tags() == null || other.tags().equals(this.tags());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.loadBalancerNames() != null) {
            sb.append("LoadBalancerNames: ").append(this.loadBalancerNames()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> loadBalancerNames = new SdkInternalList();
        private List<TagKeyOnly> tags = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(RemoveTagsRequest model) {
            this.setLoadBalancerNames(model.loadBalancerNames);
            this.setTags(model.tags);
        }

        public final Collection<String> getLoadBalancerNames() {
            return this.loadBalancerNames;
        }

        @Override
        public final Builder loadBalancerNames(Collection<String> loadBalancerNames) {
            this.loadBalancerNames = LoadBalancerNamesCopier.copy(loadBalancerNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancerNames(String ... loadBalancerNames) {
            if (this.loadBalancerNames == null) {
                this.loadBalancerNames = new SdkInternalList(loadBalancerNames.length);
            }
            for (String e : loadBalancerNames) {
                this.loadBalancerNames.add(e);
            }
            return this;
        }

        public final void setLoadBalancerNames(Collection<String> loadBalancerNames) {
            this.loadBalancerNames = LoadBalancerNamesCopier.copy(loadBalancerNames);
        }

        @SafeVarargs
        public final void setLoadBalancerNames(String ... loadBalancerNames) {
            if (this.loadBalancerNames == null) {
                this.loadBalancerNames = new SdkInternalList(loadBalancerNames.length);
            }
            for (String e : loadBalancerNames) {
                this.loadBalancerNames.add(e);
            }
        }

        public final Collection<TagKeyOnly> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Collection<TagKeyOnly> tags) {
            this.tags = TagKeyListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(TagKeyOnly ... tags) {
            if (this.tags == null) {
                this.tags = new SdkInternalList(tags.length);
            }
            for (TagKeyOnly e : tags) {
                this.tags.add(e);
            }
            return this;
        }

        public final void setTags(Collection<TagKeyOnly> tags) {
            this.tags = TagKeyListCopier.copy(tags);
        }

        @SafeVarargs
        public final void setTags(TagKeyOnly ... tags) {
            if (this.tags == null) {
                this.tags = new SdkInternalList(tags.length);
            }
            for (TagKeyOnly e : tags) {
                this.tags.add(e);
            }
        }

        public RemoveTagsRequest build() {
            return new RemoveTagsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RemoveTagsRequest> {
        public Builder loadBalancerNames(Collection<String> var1);

        public Builder loadBalancerNames(String ... var1);

        public Builder tags(Collection<TagKeyOnly> var1);

        public Builder tags(TagKeyOnly ... var1);
    }
}

