/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.elasticloadbalancing.model.SubnetsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DetachLoadBalancerFromSubnetsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DetachLoadBalancerFromSubnetsResponse> {
    private final List<String> subnets;

    private DetachLoadBalancerFromSubnetsResponse(BuilderImpl builder) {
        this.subnets = builder.subnets;
    }

    public List<String> subnets() {
        return this.subnets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.subnets() == null ? 0 : this.subnets().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetachLoadBalancerFromSubnetsResponse)) {
            return false;
        }
        DetachLoadBalancerFromSubnetsResponse other = (DetachLoadBalancerFromSubnetsResponse)((Object)obj);
        if (other.subnets() == null ^ this.subnets() == null) {
            return false;
        }
        return other.subnets() == null || other.subnets().equals(this.subnets());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.subnets() != null) {
            sb.append("Subnets: ").append(this.subnets()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> subnets = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(DetachLoadBalancerFromSubnetsResponse model) {
            this.setSubnets(model.subnets);
        }

        public final Collection<String> getSubnets() {
            return this.subnets;
        }

        @Override
        public final Builder subnets(Collection<String> subnets) {
            this.subnets = SubnetsCopier.copy(subnets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnets(String ... subnets) {
            if (this.subnets == null) {
                this.subnets = new SdkInternalList(subnets.length);
            }
            for (String e : subnets) {
                this.subnets.add(e);
            }
            return this;
        }

        public final void setSubnets(Collection<String> subnets) {
            this.subnets = SubnetsCopier.copy(subnets);
        }

        @SafeVarargs
        public final void setSubnets(String ... subnets) {
            if (this.subnets == null) {
                this.subnets = new SdkInternalList(subnets.length);
            }
            for (String e : subnets) {
                this.subnets.add(e);
            }
        }

        public DetachLoadBalancerFromSubnetsResponse build() {
            return new DetachLoadBalancerFromSubnetsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DetachLoadBalancerFromSubnetsResponse> {
        public Builder subnets(Collection<String> var1);

        public Builder subnets(String ... var1);
    }
}

