/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.elasticloadbalancing.model.LoadBalancerNamesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeLoadBalancersRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeLoadBalancersRequest> {
    private final List<String> loadBalancerNames;
    private final String marker;
    private final Integer pageSize;

    private DescribeLoadBalancersRequest(BuilderImpl builder) {
        this.loadBalancerNames = builder.loadBalancerNames;
        this.marker = builder.marker;
        this.pageSize = builder.pageSize;
    }

    public List<String> loadBalancerNames() {
        return this.loadBalancerNames;
    }

    public String marker() {
        return this.marker;
    }

    public Integer pageSize() {
        return this.pageSize;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.loadBalancerNames() == null ? 0 : this.loadBalancerNames().hashCode());
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        hashCode = 31 * hashCode + (this.pageSize() == null ? 0 : this.pageSize().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLoadBalancersRequest)) {
            return false;
        }
        DescribeLoadBalancersRequest other = (DescribeLoadBalancersRequest)((Object)obj);
        if (other.loadBalancerNames() == null ^ this.loadBalancerNames() == null) {
            return false;
        }
        if (other.loadBalancerNames() != null && !other.loadBalancerNames().equals(this.loadBalancerNames())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        if (other.marker() != null && !other.marker().equals(this.marker())) {
            return false;
        }
        if (other.pageSize() == null ^ this.pageSize() == null) {
            return false;
        }
        return other.pageSize() == null || other.pageSize().equals(this.pageSize());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.loadBalancerNames() != null) {
            sb.append("LoadBalancerNames: ").append(this.loadBalancerNames()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (this.pageSize() != null) {
            sb.append("PageSize: ").append(this.pageSize()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> loadBalancerNames = new SdkInternalList();
        private String marker;
        private Integer pageSize;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLoadBalancersRequest model) {
            this.setLoadBalancerNames(model.loadBalancerNames);
            this.setMarker(model.marker);
            this.setPageSize(model.pageSize);
        }

        public final Collection<String> getLoadBalancerNames() {
            return this.loadBalancerNames;
        }

        @Override
        public final Builder loadBalancerNames(Collection<String> loadBalancerNames) {
            this.loadBalancerNames = LoadBalancerNamesCopier.copy(loadBalancerNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancerNames(String ... loadBalancerNames) {
            if (this.loadBalancerNames == null) {
                this.loadBalancerNames = new SdkInternalList(loadBalancerNames.length);
            }
            for (String e : loadBalancerNames) {
                this.loadBalancerNames.add(e);
            }
            return this;
        }

        public final void setLoadBalancerNames(Collection<String> loadBalancerNames) {
            this.loadBalancerNames = LoadBalancerNamesCopier.copy(loadBalancerNames);
        }

        @SafeVarargs
        public final void setLoadBalancerNames(String ... loadBalancerNames) {
            if (this.loadBalancerNames == null) {
                this.loadBalancerNames = new SdkInternalList(loadBalancerNames.length);
            }
            for (String e : loadBalancerNames) {
                this.loadBalancerNames.add(e);
            }
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Integer getPageSize() {
            return this.pageSize;
        }

        @Override
        public final Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public final void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        public DescribeLoadBalancersRequest build() {
            return new DescribeLoadBalancersRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeLoadBalancersRequest> {
        public Builder loadBalancerNames(Collection<String> var1);

        public Builder loadBalancerNames(String ... var1);

        public Builder marker(String var1);

        public Builder pageSize(Integer var1);
    }
}

