/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.elasticloadbalancing.model.InstanceState;
import software.amazon.awssdk.services.elasticloadbalancing.model.InstanceStatesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeInstanceHealthResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeInstanceHealthResponse> {
    private final List<InstanceState> instanceStates;

    private DescribeInstanceHealthResponse(BuilderImpl builder) {
        this.instanceStates = builder.instanceStates;
    }

    public List<InstanceState> instanceStates() {
        return this.instanceStates;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.instanceStates() == null ? 0 : this.instanceStates().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstanceHealthResponse)) {
            return false;
        }
        DescribeInstanceHealthResponse other = (DescribeInstanceHealthResponse)((Object)obj);
        if (other.instanceStates() == null ^ this.instanceStates() == null) {
            return false;
        }
        return other.instanceStates() == null || other.instanceStates().equals(this.instanceStates());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.instanceStates() != null) {
            sb.append("InstanceStates: ").append(this.instanceStates()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<InstanceState> instanceStates = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstanceHealthResponse model) {
            this.setInstanceStates(model.instanceStates);
        }

        public final Collection<InstanceState> getInstanceStates() {
            return this.instanceStates;
        }

        @Override
        public final Builder instanceStates(Collection<InstanceState> instanceStates) {
            this.instanceStates = InstanceStatesCopier.copy(instanceStates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceStates(InstanceState ... instanceStates) {
            if (this.instanceStates == null) {
                this.instanceStates = new SdkInternalList(instanceStates.length);
            }
            for (InstanceState e : instanceStates) {
                this.instanceStates.add(e);
            }
            return this;
        }

        public final void setInstanceStates(Collection<InstanceState> instanceStates) {
            this.instanceStates = InstanceStatesCopier.copy(instanceStates);
        }

        @SafeVarargs
        public final void setInstanceStates(InstanceState ... instanceStates) {
            if (this.instanceStates == null) {
                this.instanceStates = new SdkInternalList(instanceStates.length);
            }
            for (InstanceState e : instanceStates) {
                this.instanceStates.add(e);
            }
        }

        public DescribeInstanceHealthResponse build() {
            return new DescribeInstanceHealthResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeInstanceHealthResponse> {
        public Builder instanceStates(Collection<InstanceState> var1);

        public Builder instanceStates(InstanceState ... var1);
    }
}

