/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticinference.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The memory information of an Elastic Inference Accelerator type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MemoryInfo implements SdkPojo, Serializable, ToCopyableBuilder<MemoryInfo.Builder, MemoryInfo> {
    private static final SdkField<Integer> SIZE_IN_MIB_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("sizeInMiB").getter(getter(MemoryInfo::sizeInMiB)).setter(setter(Builder::sizeInMiB))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sizeInMiB").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIZE_IN_MIB_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer sizeInMiB;

    private MemoryInfo(BuilderImpl builder) {
        this.sizeInMiB = builder.sizeInMiB;
    }

    /**
     * <p>
     * The size in mebibytes of the Elastic Inference Accelerator type.
     * </p>
     * 
     * @return The size in mebibytes of the Elastic Inference Accelerator type.
     */
    public final Integer sizeInMiB() {
        return sizeInMiB;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sizeInMiB());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MemoryInfo)) {
            return false;
        }
        MemoryInfo other = (MemoryInfo) obj;
        return Objects.equals(sizeInMiB(), other.sizeInMiB());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MemoryInfo").add("SizeInMiB", sizeInMiB()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sizeInMiB":
            return Optional.ofNullable(clazz.cast(sizeInMiB()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MemoryInfo, T> g) {
        return obj -> g.apply((MemoryInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MemoryInfo> {
        /**
         * <p>
         * The size in mebibytes of the Elastic Inference Accelerator type.
         * </p>
         * 
         * @param sizeInMiB
         *        The size in mebibytes of the Elastic Inference Accelerator type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sizeInMiB(Integer sizeInMiB);
    }

    static final class BuilderImpl implements Builder {
        private Integer sizeInMiB;

        private BuilderImpl() {
        }

        private BuilderImpl(MemoryInfo model) {
            sizeInMiB(model.sizeInMiB);
        }

        public final Integer getSizeInMiB() {
            return sizeInMiB;
        }

        @Override
        public final Builder sizeInMiB(Integer sizeInMiB) {
            this.sizeInMiB = sizeInMiB;
            return this;
        }

        public final void setSizeInMiB(Integer sizeInMiB) {
            this.sizeInMiB = sizeInMiB;
        }

        @Override
        public MemoryInfo build() {
            return new MemoryInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
