/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticinference.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticinference.model.LocationType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AcceleratorTypeOffering
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AcceleratorTypeOffering> {
    private static final SdkField<String> ACCELERATOR_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AcceleratorTypeOffering.getter(AcceleratorTypeOffering::acceleratorType)).setter(AcceleratorTypeOffering.setter(Builder::acceleratorType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("acceleratorType").build()}).build();
    private static final SdkField<String> LOCATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AcceleratorTypeOffering.getter(AcceleratorTypeOffering::locationTypeAsString)).setter(AcceleratorTypeOffering.setter(Builder::locationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("locationType").build()}).build();
    private static final SdkField<String> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AcceleratorTypeOffering.getter(AcceleratorTypeOffering::location)).setter(AcceleratorTypeOffering.setter(Builder::location)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCELERATOR_TYPE_FIELD, LOCATION_TYPE_FIELD, LOCATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String acceleratorType;
    private final String locationType;
    private final String location;

    private AcceleratorTypeOffering(BuilderImpl builder) {
        this.acceleratorType = builder.acceleratorType;
        this.locationType = builder.locationType;
        this.location = builder.location;
    }

    public String acceleratorType() {
        return this.acceleratorType;
    }

    public LocationType locationType() {
        return LocationType.fromValue(this.locationType);
    }

    public String locationTypeAsString() {
        return this.locationType;
    }

    public String location() {
        return this.location;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.acceleratorType());
        hashCode = 31 * hashCode + Objects.hashCode(this.locationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AcceleratorTypeOffering)) {
            return false;
        }
        AcceleratorTypeOffering other = (AcceleratorTypeOffering)obj;
        return Objects.equals(this.acceleratorType(), other.acceleratorType()) && Objects.equals(this.locationTypeAsString(), other.locationTypeAsString()) && Objects.equals(this.location(), other.location());
    }

    public String toString() {
        return ToString.builder((String)"AcceleratorTypeOffering").add("AcceleratorType", (Object)this.acceleratorType()).add("LocationType", (Object)this.locationTypeAsString()).add("Location", (Object)this.location()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "acceleratorType": {
                return Optional.ofNullable(clazz.cast(this.acceleratorType()));
            }
            case "locationType": {
                return Optional.ofNullable(clazz.cast(this.locationTypeAsString()));
            }
            case "location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AcceleratorTypeOffering, T> g) {
        return obj -> g.apply((AcceleratorTypeOffering)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String acceleratorType;
        private String locationType;
        private String location;

        private BuilderImpl() {
        }

        private BuilderImpl(AcceleratorTypeOffering model) {
            this.acceleratorType(model.acceleratorType);
            this.locationType(model.locationType);
            this.location(model.location);
        }

        public final String getAcceleratorType() {
            return this.acceleratorType;
        }

        @Override
        public final Builder acceleratorType(String acceleratorType) {
            this.acceleratorType = acceleratorType;
            return this;
        }

        public final void setAcceleratorType(String acceleratorType) {
            this.acceleratorType = acceleratorType;
        }

        public final String getLocationType() {
            return this.locationType;
        }

        @Override
        public final Builder locationType(String locationType) {
            this.locationType = locationType;
            return this;
        }

        @Override
        public final Builder locationType(LocationType locationType) {
            this.locationType(locationType == null ? null : locationType.toString());
            return this;
        }

        public final void setLocationType(String locationType) {
            this.locationType = locationType;
        }

        public final String getLocation() {
            return this.location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        public AcceleratorTypeOffering build() {
            return new AcceleratorTypeOffering(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AcceleratorTypeOffering> {
        public Builder acceleratorType(String var1);

        public Builder locationType(String var1);

        public Builder locationType(LocationType var1);

        public Builder location(String var1);
    }
}

