/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EnvironmentLink
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EnvironmentLink> {
    private static final SdkField<String> LINK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(EnvironmentLink.getter(EnvironmentLink::linkName)).setter(EnvironmentLink.setter(Builder::linkName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LinkName").build()}).build();
    private static final SdkField<String> ENVIRONMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(EnvironmentLink.getter(EnvironmentLink::environmentName)).setter(EnvironmentLink.setter(Builder::environmentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LINK_NAME_FIELD, ENVIRONMENT_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String linkName;
    private final String environmentName;

    private EnvironmentLink(BuilderImpl builder) {
        this.linkName = builder.linkName;
        this.environmentName = builder.environmentName;
    }

    public String linkName() {
        return this.linkName;
    }

    public String environmentName() {
        return this.environmentName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.linkName());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentLink)) {
            return false;
        }
        EnvironmentLink other = (EnvironmentLink)obj;
        return Objects.equals(this.linkName(), other.linkName()) && Objects.equals(this.environmentName(), other.environmentName());
    }

    public String toString() {
        return ToString.builder((String)"EnvironmentLink").add("LinkName", (Object)this.linkName()).add("EnvironmentName", (Object)this.environmentName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LinkName": {
                return Optional.ofNullable(clazz.cast(this.linkName()));
            }
            case "EnvironmentName": {
                return Optional.ofNullable(clazz.cast(this.environmentName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EnvironmentLink, T> g) {
        return obj -> g.apply((EnvironmentLink)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String linkName;
        private String environmentName;

        private BuilderImpl() {
        }

        private BuilderImpl(EnvironmentLink model) {
            this.linkName(model.linkName);
            this.environmentName(model.environmentName);
        }

        public final String getLinkName() {
            return this.linkName;
        }

        @Override
        public final Builder linkName(String linkName) {
            this.linkName = linkName;
            return this;
        }

        public final void setLinkName(String linkName) {
            this.linkName = linkName;
        }

        public final String getEnvironmentName() {
            return this.environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        public EnvironmentLink build() {
            return new EnvironmentLink(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EnvironmentLink> {
        public Builder linkName(String var1);

        public Builder environmentName(String var1);
    }
}

