/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OptionRestrictionRegex
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OptionRestrictionRegex> {
    private static final SdkField<String> PATTERN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(OptionRestrictionRegex.getter(OptionRestrictionRegex::pattern)).setter(OptionRestrictionRegex.setter(Builder::pattern)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Pattern").build()}).build();
    private static final SdkField<String> LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(OptionRestrictionRegex.getter(OptionRestrictionRegex::label)).setter(OptionRestrictionRegex.setter(Builder::label)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Label").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PATTERN_FIELD, LABEL_FIELD));
    private static final long serialVersionUID = 1L;
    private final String pattern;
    private final String label;

    private OptionRestrictionRegex(BuilderImpl builder) {
        this.pattern = builder.pattern;
        this.label = builder.label;
    }

    public String pattern() {
        return this.pattern;
    }

    public String label() {
        return this.label;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.pattern());
        hashCode = 31 * hashCode + Objects.hashCode(this.label());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OptionRestrictionRegex)) {
            return false;
        }
        OptionRestrictionRegex other = (OptionRestrictionRegex)obj;
        return Objects.equals(this.pattern(), other.pattern()) && Objects.equals(this.label(), other.label());
    }

    public String toString() {
        return ToString.builder((String)"OptionRestrictionRegex").add("Pattern", (Object)this.pattern()).add("Label", (Object)this.label()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Pattern": {
                return Optional.ofNullable(clazz.cast(this.pattern()));
            }
            case "Label": {
                return Optional.ofNullable(clazz.cast(this.label()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OptionRestrictionRegex, T> g) {
        return obj -> g.apply((OptionRestrictionRegex)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String pattern;
        private String label;

        private BuilderImpl() {
        }

        private BuilderImpl(OptionRestrictionRegex model) {
            this.pattern(model.pattern);
            this.label(model.label);
        }

        public final String getPattern() {
            return this.pattern;
        }

        @Override
        public final Builder pattern(String pattern) {
            this.pattern = pattern;
            return this;
        }

        public final void setPattern(String pattern) {
            this.pattern = pattern;
        }

        public final String getLabel() {
            return this.label;
        }

        @Override
        public final Builder label(String label) {
            this.label = label;
            return this;
        }

        public final void setLabel(String label) {
            this.label = label;
        }

        public OptionRestrictionRegex build() {
            return new OptionRestrictionRegex(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OptionRestrictionRegex> {
        public Builder pattern(String var1);

        public Builder label(String var1);
    }
}

